/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.screen.clock;

import com.github.minecraftschurlimods.bibliocraft.client.SpriteButton;
import com.github.minecraftschurlimods.bibliocraft.client.screen.clock.ClockTriggerEditScreen;
import com.github.minecraftschurlimods.bibliocraft.client.screen.clock.ClockTriggerPanel;
import com.github.minecraftschurlimods.bibliocraft.content.clock.ClockTrigger;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.ClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ClockTriggerElement
extends Screen {
    public static final int WIDTH = 160;
    public static final int HEIGHT = 20;
    private static final ResourceLocation BACKGROUND = BCUtil.modLoc("textures/gui/clock_trigger.png");
    private static final ResourceLocation EDIT = BCUtil.modLoc("edit");
    private static final ResourceLocation EDIT_HIGHLIGHTED = BCUtil.modLoc("edit_highlighted");
    private static final ResourceLocation DELETE = BCUtil.modLoc("delete");
    private static final ResourceLocation DELETE_HIGHLIGHTED = BCUtil.modLoc("delete_highlighted");
    private static final Component DELETE_TRIGGER = Component.translatable((String)"gui.bibliocraft.clock.delete_trigger");
    private static final Component EDIT_TRIGGER = Component.translatable((String)"gui.bibliocraft.clock.edit_trigger");
    private static final Component EMIT_REDSTONE = Component.translatable((String)"gui.bibliocraft.clock.emit_redstone");
    private static final Component EMIT_SOUND = Component.translatable((String)"gui.bibliocraft.clock.emit_sound");
    private static final Component SEPARATOR = Component.translatable((String)"gui.bibliocraft.clock.time_separator");
    private static final ItemStack REDSTONE = new ItemStack((ItemLike)Items.REDSTONE);
    private static final ItemStack NOTE_BLOCK = new ItemStack((ItemLike)Items.NOTE_BLOCK);
    public final ClockTriggerPanel owner;
    private final ClockTrigger trigger;
    private final int listSize;
    private final Button editButton;
    private final Button deleteButton;

    public ClockTriggerElement(ClockTrigger trigger, ClockTriggerPanel owner, int listSize) {
        super((Component)Component.literal((String)String.format("%02d%s%02d", trigger.hour(), SEPARATOR.getString(), trigger.minute())));
        this.width = 160;
        this.height = 20;
        this.trigger = trigger;
        this.owner = owner;
        this.listSize = listSize;
        int width = owner.hasScrollbar(listSize) ? 154 : 160;
        this.editButton = (Button)this.addRenderableWidget((GuiEventListener)new SpriteButton.RegularAndHighlightSprite(EDIT, EDIT_HIGHLIGHTED, width - 34, 2, 16, 16, $ -> Minecraft.getInstance().pushGuiLayer((Screen)new ClockTriggerEditScreen(owner.owner, trigger))));
        this.deleteButton = (Button)this.addRenderableWidget((GuiEventListener)new SpriteButton.RegularAndHighlightSprite(DELETE, DELETE_HIGHLIGHTED, width - 18, 2, 16, 16, $ -> owner.owner.removeTrigger(trigger)));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        boolean hasScrollbar = this.owner.hasScrollbar(this.listSize);
        graphics.blit(BACKGROUND, 0, 0, 0, hasScrollbar ? 20 : 0, hasScrollbar ? 154 : 160, 20);
        PoseStack pose = graphics.pose();
        MultiBufferSource.BufferSource buffer = graphics.bufferSource();
        pose.pushPose();
        pose.translate(8.0f, 12.0f, 0.0f);
        pose.scale(16.0f, -16.0f, 0.0f);
        pose.translate(0.125, 0.125, 0.0);
        if (this.trigger.redstone()) {
            ClientUtil.renderGuiItem(REDSTONE, pose, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.NO_OVERLAY);
        }
        pose.translate(1.0625, 0.0, 0.0);
        if (this.trigger.sound()) {
            ClientUtil.renderGuiItem(NOTE_BLOCK, pose, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.NO_OVERLAY);
        }
        pose.popPose();
        graphics.drawString(Minecraft.getInstance().font, this.getTitle(), 36, 7, 0x404040, false);
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (mouseY >= 2 && mouseY < 18) {
            if (this.trigger.redstone() && mouseX >= 2 && mouseX < 18) {
                graphics.renderTooltip(Minecraft.getInstance().font, EMIT_REDSTONE, mouseX, mouseY);
            } else if (this.trigger.sound() && mouseX >= 19 && mouseX < 37) {
                graphics.renderTooltip(Minecraft.getInstance().font, EMIT_SOUND, mouseX, mouseY);
            } else if (this.editButton.isHovered()) {
                graphics.renderTooltip(Minecraft.getInstance().font, EDIT_TRIGGER, mouseX, mouseY);
            } else if (this.deleteButton.isHovered()) {
                graphics.renderTooltip(Minecraft.getInstance().font, DELETE_TRIGGER, mouseX, mouseY);
            }
        }
    }
}

