/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.model;

import com.github.minecraftschurlimods.bibliocraft.client.model.DynamicBlockModel;
import com.github.minecraftschurlimods.bibliocraft.content.bookcase.BookcaseBlockEntity;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.ElementsModel;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.Nullable;

public class BookcaseModel
extends DynamicBlockModel {
    public static final IGeometryLoader<BookcaseGeometry> LOADER = (jsonObject, context) -> {
        jsonObject.remove("loader");
        BlockModel base = (BlockModel)context.deserialize((JsonElement)jsonObject, BlockModel.class);
        BlockModel[] books = new BlockModel[16];
        for (int i = 0; i < 16; ++i) {
            books[i] = (BlockModel)context.deserialize((JsonElement)GsonHelper.getAsJsonObject((JsonObject)jsonObject, (String)("book_" + i)), BlockModel.class);
        }
        return new BookcaseGeometry(base, books);
    };
    private final BakedModel base;
    private final BakedModel[] books;

    public BookcaseModel(boolean useAmbientOcclusion, boolean isGui3d, boolean usesBlockLight, TextureAtlasSprite particle, BakedModel base, BakedModel[] books) {
        super(useAmbientOcclusion, isGui3d, usesBlockLight, particle);
        this.base = base;
        this.books = books;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.base.getQuads(state, side, rand, extraData, renderType));
        for (int i = 0; i < this.books.length; ++i) {
            Boolean book = (Boolean)extraData.get(BookcaseBlockEntity.MODEL_PROPERTIES.get(i));
            if (book == null || !book.booleanValue()) continue;
            quads.addAll(this.books[i].getQuads(state, side, rand, extraData, renderType));
        }
        return quads;
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        return this.base.applyTransform(transformType, poseStack, applyLeftHandTransform);
    }

    public static class BookcaseGeometry
    implements IUnbakedGeometry<BookcaseGeometry> {
        private final BlockModel base;
        private final BlockModel[] books;

        public BookcaseGeometry(BlockModel base, BlockModel[] books) {
            this.base = base;
            this.books = books;
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
            BakedModel base = new ElementsModel(this.base.getElements()).bake(context, baker, spriteGetter, modelState, overrides);
            BakedModel[] books = new BakedModel[16];
            SimpleModelState bookState = new SimpleModelState(modelState.getRotation(), modelState.isUvLocked());
            boolean useBlockLight = context.useBlockLight();
            for (int j = 0; j < books.length; ++j) {
                books[j] = this.books[j].bake(baker, this.books[j], spriteGetter, (ModelState)bookState, useBlockLight);
            }
            return new BookcaseModel(context.useAmbientOcclusion(), context.isGui3d(), useBlockLight, spriteGetter.apply(context.getMaterial("particle")), base, books);
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
            this.base.resolveParents(modelGetter);
            for (BlockModel book : this.books) {
                book.resolveParents(modelGetter);
            }
        }
    }
}

