/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.api.datagen;

import com.github.minecraftschurlimods.bibliocraft.api.BibliocraftApi;
import com.github.minecraftschurlimods.bibliocraft.api.woodtype.BibliocraftWoodType;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public interface BibliocraftDatagenHelper {
    public void addWoodTypeToGenerate(BibliocraftWoodType var1);

    public List<BibliocraftWoodType> getWoodTypesToGenerate();

    public void generateEnglishTranslationsFor(LanguageProvider var1, BibliocraftWoodType var2);

    public void generateBlockStatesFor(BlockStateProvider var1, BibliocraftWoodType var2);

    public void generateItemModelsFor(ItemModelProvider var1, BibliocraftWoodType var2);

    public void generateBlockTagsFor(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> var1, BibliocraftWoodType var2);

    public void generateItemTagsFor(Function<TagKey<Item>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> var1, BibliocraftWoodType var2);

    public void generateLootTablesFor(BiConsumer<Block, LootTable.Builder> var1, BibliocraftWoodType var2);

    public void generateRecipesFor(RecipeOutput var1, BibliocraftWoodType var2, String var3);

    public void generateAllFor(BibliocraftWoodType var1, String var2, GatherDataEvent var3, LanguageProvider var4, BlockTagsProvider var5, ItemTagsProvider var6);

    default public void addWoodTypesToGenerateByModid(String modid) {
        BibliocraftApi.getWoodTypeRegistry().getAll().stream().filter(e -> e.getNamespace().equals(modid)).forEach(this::addWoodTypeToGenerate);
    }

    default public void generateEnglishTranslations(LanguageProvider provider) {
        this.getWoodTypesToGenerate().forEach(woodType -> this.generateEnglishTranslationsFor(provider, (BibliocraftWoodType)woodType));
    }

    default public void generateBlockStates(BlockStateProvider provider) {
        this.getWoodTypesToGenerate().forEach(woodType -> this.generateBlockStatesFor(provider, (BibliocraftWoodType)woodType));
    }

    default public void generateItemModels(ItemModelProvider provider) {
        this.getWoodTypesToGenerate().forEach(woodType -> this.generateItemModelsFor(provider, (BibliocraftWoodType)woodType));
    }

    default public void generateBlockTags(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagAccessor) {
        this.getWoodTypesToGenerate().forEach(woodType -> this.generateBlockTagsFor(tagAccessor, (BibliocraftWoodType)woodType));
    }

    default public void generateItemTags(Function<TagKey<Item>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> tagAccessor) {
        this.getWoodTypesToGenerate().forEach(woodType -> this.generateItemTagsFor(tagAccessor, (BibliocraftWoodType)woodType));
    }

    default public void generateLootTables(BiConsumer<Block, LootTable.Builder> lootTableAdder) {
        this.getWoodTypesToGenerate().forEach(woodType -> this.generateLootTablesFor(lootTableAdder, (BibliocraftWoodType)woodType));
    }

    default public void generateRecipes(RecipeOutput output, String modId) {
        this.getWoodTypesToGenerate().forEach(woodType -> this.generateRecipesFor(output, (BibliocraftWoodType)woodType, modId));
    }

    default public void generateAll(String modId, GatherDataEvent event, LanguageProvider englishLanguageProvider, BlockTagsProvider blockTagsProvider, ItemTagsProvider itemTagsProvider) {
        this.getWoodTypesToGenerate().forEach(woodType -> this.generateAllFor((BibliocraftWoodType)woodType, modId, event, englishLanguageProvider, blockTagsProvider, itemTagsProvider));
    }
}

