/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft;

import com.github.minecraftschurlimods.bibliocraft.api.BibliocraftApi;
import com.github.minecraftschurlimods.bibliocraft.api.lockandkey.RegisterLockAndKeyBehaviorEvent;
import com.github.minecraftschurlimods.bibliocraft.api.woodtype.RegisterBibliocraftWoodTypesEvent;
import com.github.minecraftschurlimods.bibliocraft.apiimpl.BibliocraftWoodTypeRegistryImpl;
import com.github.minecraftschurlimods.bibliocraft.apiimpl.LockAndKeyBehaviorsImpl;
import com.github.minecraftschurlimods.bibliocraft.content.clipboard.ClipboardSyncPacket;
import com.github.minecraftschurlimods.bibliocraft.content.clock.ClockSyncPacket;
import com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog.StockroomCatalogListPacket;
import com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog.StockroomCatalogRequestListPacket;
import com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog.StockroomCatalogSyncPacket;
import com.github.minecraftschurlimods.bibliocraft.init.BCBlockEntities;
import com.github.minecraftschurlimods.bibliocraft.init.BCEntities;
import com.github.minecraftschurlimods.bibliocraft.init.BCRegistries;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.content.BCBlockEntity;
import java.util.Objects;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;

public final class EventHandler {

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="bibliocraft")
    public static final class ModBus {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        private static void constructMod(FMLConstructModEvent event) {
            ((BibliocraftWoodTypeRegistryImpl)BibliocraftApi.getWoodTypeRegistry()).register();
            BCRegistries.init(Objects.requireNonNull(((ModContainer)ModList.get().getModContainerById("bibliocraft").orElseThrow()).getEventBus()));
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        private static void commonSetup(FMLCommonSetupEvent event) {
            ((LockAndKeyBehaviorsImpl)BibliocraftApi.getLockAndKeyBehaviors()).register();
        }

        @SubscribeEvent
        private static void entityAttributeCreation(EntityAttributeCreationEvent event) {
            event.put(BCEntities.FANCY_ARMOR_STAND.get(), LivingEntity.createLivingAttributes().build());
        }

        @SubscribeEvent
        private static void registerCapabilities(RegisterCapabilitiesEvent event) {
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BCBlockEntities.BOOKCASE.get(), BCBlockEntity::getCapability);
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BCBlockEntities.COOKIE_JAR.get(), BCBlockEntity::getCapability);
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BCBlockEntities.DINNER_PLATE.get(), BCBlockEntity::getCapability);
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BCBlockEntities.DISC_RACK.get(), BCBlockEntity::getCapability);
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BCBlockEntities.DISPLAY_CASE.get(), BCBlockEntity::getCapability);
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BCBlockEntities.FANCY_ARMOR_STAND.get(), BCBlockEntity::getCapability);
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BCBlockEntities.LABEL.get(), BCBlockEntity::getCapability);
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BCBlockEntities.POTION_SHELF.get(), BCBlockEntity::getCapability);
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BCBlockEntities.SHELF.get(), BCBlockEntity::getCapability);
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BCBlockEntities.SWORD_PEDESTAL.get(), BCBlockEntity::getCapability);
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BCBlockEntities.TABLE.get(), BCBlockEntity::getCapability);
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BCBlockEntities.TOOL_RACK.get(), BCBlockEntity::getCapability);
        }

        @SubscribeEvent
        private static void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
            event.registrar("bibliocraft").playToServer(ClipboardSyncPacket.TYPE, ClipboardSyncPacket.STREAM_CODEC, ClipboardSyncPacket::handle).playBidirectional(ClockSyncPacket.TYPE, ClockSyncPacket.STREAM_CODEC, ClockSyncPacket::handle).playToServer(StockroomCatalogSyncPacket.TYPE, StockroomCatalogSyncPacket.STREAM_CODEC, StockroomCatalogSyncPacket::handle).playToServer(StockroomCatalogRequestListPacket.TYPE, StockroomCatalogRequestListPacket.STREAM_CODEC, StockroomCatalogRequestListPacket::handle).playToClient(StockroomCatalogListPacket.TYPE, StockroomCatalogListPacket.STREAM_CODEC, StockroomCatalogListPacket::handle);
        }

        @SubscribeEvent
        private static void registerLockAndKeyBehaviors(RegisterLockAndKeyBehaviorEvent event) {
            event.register(BaseContainerBlockEntity.class, be -> be.lockKey, (be, lock) -> {
                be.lockKey = lock;
            }, BaseContainerBlockEntity::getDisplayName);
            event.register(BeaconBlockEntity.class, be -> be.lockKey, (be, lock) -> {
                be.lockKey = lock;
            }, BeaconBlockEntity::getDisplayName);
            event.register(BCBlockEntity.class, BCBlockEntity::getLockKey, BCBlockEntity::setLockKey, be -> BCUtil.getNameAtPos(Objects.requireNonNull(be.getLevel()), be.getBlockPos()));
        }

        @SubscribeEvent
        private static void registerBibliocraftWoodTypes(RegisterBibliocraftWoodTypesEvent event) {
            ModBus.registerVanilla(event, WoodType.OAK, Blocks.OAK_PLANKS, BlockFamilies.OAK_PLANKS);
            ModBus.registerVanilla(event, WoodType.SPRUCE, Blocks.SPRUCE_PLANKS, BlockFamilies.SPRUCE_PLANKS);
            ModBus.registerVanilla(event, WoodType.BIRCH, Blocks.BIRCH_PLANKS, BlockFamilies.BIRCH_PLANKS);
            ModBus.registerVanilla(event, WoodType.JUNGLE, Blocks.JUNGLE_PLANKS, BlockFamilies.JUNGLE_PLANKS);
            ModBus.registerVanilla(event, WoodType.ACACIA, Blocks.ACACIA_PLANKS, BlockFamilies.ACACIA_PLANKS);
            ModBus.registerVanilla(event, WoodType.DARK_OAK, Blocks.DARK_OAK_PLANKS, BlockFamilies.DARK_OAK_PLANKS);
            ModBus.registerVanilla(event, WoodType.CRIMSON, Blocks.CRIMSON_PLANKS, BlockFamilies.CRIMSON_PLANKS);
            ModBus.registerVanilla(event, WoodType.WARPED, Blocks.WARPED_PLANKS, BlockFamilies.WARPED_PLANKS);
            ModBus.registerVanilla(event, WoodType.MANGROVE, Blocks.MANGROVE_PLANKS, BlockFamilies.MANGROVE_PLANKS);
            ModBus.registerVanilla(event, WoodType.BAMBOO, Blocks.BAMBOO_PLANKS, BlockFamilies.BAMBOO_PLANKS);
            ModBus.registerVanilla(event, WoodType.CHERRY, Blocks.CHERRY_PLANKS, BlockFamilies.CHERRY_PLANKS);
        }

        private static void registerVanilla(RegisterBibliocraftWoodTypesEvent event, WoodType woodType, Block planks, BlockFamily family) {
            event.register(BCUtil.mcLoc(woodType.name()), woodType, () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)planks), BCUtil.mcLoc("block/" + woodType.name() + "_planks"), () -> family);
        }
    }
}

