/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Screens;

import com.darkere.crashutils.Screens.GuiTools;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class CUButton
extends Button {
    List<String> tooltips;

    public CUButton(int xPos, int yPos, int width, int height, Component displayString, Button.OnPress handler, String tooltip) {
        super(xPos, yPos, width, height, displayString, handler, DEFAULT_NARRATION);
        this.tooltips = List.of(tooltip);
    }

    public CUButton(int xPos, int yPos, int width, int height, Component displayString, Button.OnPress handler, List<String> tooltip) {
        super(xPos, yPos, width, height, displayString, handler, DEFAULT_NARRATION);
        this.tooltips = tooltip;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        int k = !this.active ? 0 : (this.isHoveredOrFocused() ? 2 : 1);
        guiGraphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        Component buttonText = this.getMessage();
        guiGraphics.drawCenteredString(mc.font, buttonText, this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, this.getFGColor());
        if (this.isHovered()) {
            GuiTools.drawTextToolTip(guiGraphics, this.tooltips, mouseX, mouseY);
        }
    }

    public int getFGColor() {
        return this.isActive() ? 0xFFFFFF : 0xA0A0A0;
    }

    public boolean mouseClicked(double p_93641_, double p_93642_, int p_93643_) {
        if (this.isActive() && this.visible) {
            boolean flag;
            if (this.isValidClickButton(p_93643_) && (flag = this.clicked(p_93641_, p_93642_))) {
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                this.onClick(p_93641_, p_93642_);
                return true;
            }
            return false;
        }
        return false;
    }

    public static interface OnTooltip {
        public void onTooltip(Button var1, PoseStack var2, int var3, int var4);
    }
}

