/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.registry;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.client.entities.SpiritJobClient;
import com.klikli_dev.occultism.common.entity.job.CleanerJob;
import com.klikli_dev.occultism.common.entity.job.ClearWeatherJob;
import com.klikli_dev.occultism.common.entity.job.CrusherJob;
import com.klikli_dev.occultism.common.entity.job.DayTimeJob;
import com.klikli_dev.occultism.common.entity.job.LumberjackJob;
import com.klikli_dev.occultism.common.entity.job.ManageMachineJob;
import com.klikli_dev.occultism.common.entity.job.NightTimeJob;
import com.klikli_dev.occultism.common.entity.job.RainWeatherJob;
import com.klikli_dev.occultism.common.entity.job.SmelterJob;
import com.klikli_dev.occultism.common.entity.job.SpiritJobFactory;
import com.klikli_dev.occultism.common.entity.job.ThunderWeatherJob;
import com.klikli_dev.occultism.common.entity.job.TraderJob;
import com.klikli_dev.occultism.common.entity.job.TransportItemsJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class OccultismSpiritJobs {
    public static final ResourceKey<Registry<SpiritJobFactory>> JOBS_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_job_factories"));
    public static DeferredRegister<SpiritJobFactory> JOBS = DeferredRegister.create(JOBS_KEY, (String)"occultism");
    public static final Registry<SpiritJobFactory> REGISTRY = JOBS.makeRegistry(builder -> {});
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> LUMBERJACK = JOBS.register("lumberjack", () -> new SpiritJobFactory(LumberjackJob::new, SpiritJobClient.create("lumberjack")));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> MANAGE_MACHINE = JOBS.register("manage_machine", () -> new SpiritJobFactory(ManageMachineJob::new, SpiritJobClient.create("machine_manager")));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> TRANSPORT_ITEMS = JOBS.register("transport_items", () -> new SpiritJobFactory(TransportItemsJob::new, SpiritJobClient.create("transporter")));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> CLEANER = JOBS.register("cleaner", () -> new SpiritJobFactory(CleanerJob::new, SpiritJobClient.create("janitor")));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> TRADE_OTHERSTONE_T1 = JOBS.register("trade_otherstone_t1", () -> new SpiritJobFactory(entity -> {
        TraderJob job = new TraderJob((SpiritEntity)entity, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_trade/stone_to_otherstone"));
        job.setTimeToConvert(15);
        job.setMaxTradesPerRound(4);
        return job;
    }, SpiritJobClient.create("otherstone_trader")));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> TRADE_OTHERWORLD_SAPLINGS_T2 = JOBS.register("trade_otherworld_saplings_t1", () -> new SpiritJobFactory(entity -> {
        TraderJob job = new TraderJob((SpiritEntity)entity, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_trade/otherworld_sapling"));
        job.setTimeToConvert(20);
        job.setMaxTradesPerRound(1);
        return job;
    }, SpiritJobClient.create("sapling_trader")));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> CRUSH_TIER1 = JOBS.register("crush_tier1", () -> new SpiritJobFactory(entity -> new CrusherJob((SpiritEntity)entity, () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier1CrusherTimeMultiplier.get()).floatValue()), () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier1CrusherOutputMultiplier.get()).floatValue()), () -> 1), SpiritJobClient.create("crusher")));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> CRUSH_TIER2 = JOBS.register("crush_tier2", () -> new SpiritJobFactory(entity -> new CrusherJob((SpiritEntity)entity, () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier2CrusherTimeMultiplier.get()).floatValue()), () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier2CrusherOutputMultiplier.get()).floatValue()), () -> 2), SpiritJobClient.create("crusher")));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> CRUSH_TIER3 = JOBS.register("crush_tier3", () -> new SpiritJobFactory(entity -> new CrusherJob((SpiritEntity)entity, () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier3CrusherTimeMultiplier.get()).floatValue()), () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier3CrusherOutputMultiplier.get()).floatValue()), () -> 3), SpiritJobClient.create("crusher")));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> CRUSH_TIER4 = JOBS.register("crush_tier4", () -> new SpiritJobFactory(entity -> new CrusherJob((SpiritEntity)entity, () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier4CrusherTimeMultiplier.get()).floatValue()), () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier4CrusherOutputMultiplier.get()).floatValue()), () -> 4), SpiritJobClient.create("crusher")));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> SMELT_TIER1 = JOBS.register("smelt_tier1", () -> new SpiritJobFactory(entity -> new SmelterJob((SpiritEntity)entity, () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier1SmelterTimeMultiplier.get()).floatValue())), SpiritJobClient.create("smelter")));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> SMELT_TIER2 = JOBS.register("smelt_tier2", () -> new SpiritJobFactory(entity -> new SmelterJob((SpiritEntity)entity, () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier2SmelterTimeMultiplier.get()).floatValue())), SpiritJobClient.create("smelter")));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> SMELT_TIER3 = JOBS.register("smelt_tier3", () -> new SpiritJobFactory(entity -> new SmelterJob((SpiritEntity)entity, () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier3SmelterTimeMultiplier.get()).floatValue())), SpiritJobClient.create("smelter")));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> SMELT_TIER4 = JOBS.register("smelt_tier4", () -> new SpiritJobFactory(entity -> new SmelterJob((SpiritEntity)entity, () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier4SmelterTimeMultiplier.get()).floatValue())), SpiritJobClient.create("smelter")));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> CLEAR_WEATHER = JOBS.register("clear_weather", () -> new SpiritJobFactory(entity -> new ClearWeatherJob((SpiritEntity)entity, 300), SpiritJobClient.create()));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> RAIN_WEATHER = JOBS.register("rain_weather", () -> new SpiritJobFactory(entity -> new RainWeatherJob((SpiritEntity)entity, 600), SpiritJobClient.create()));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> THUNDER_WEATHER = JOBS.register("thunder_weather", () -> new SpiritJobFactory(entity -> new ThunderWeatherJob((SpiritEntity)entity, 1200), SpiritJobClient.create()));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> DAY_TIME = JOBS.register("day_time", () -> new SpiritJobFactory(entity -> new DayTimeJob((SpiritEntity)entity, 100), SpiritJobClient.create()));
    public static final DeferredHolder<SpiritJobFactory, SpiritJobFactory> NIGHT_TIME = JOBS.register("night_time", () -> new SpiritJobFactory(entity -> new NightTimeJob((SpiritEntity)entity, 100), SpiritJobClient.create()));
}

