/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.network.IMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class MessageSetTagFilterText
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"set_tag_filter_text");
    public static final CustomPacketPayload.Type<MessageSetTagFilterText> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageSetTagFilterText> STREAM_CODEC = CustomPacketPayload.codec(MessageSetTagFilterText::encode, MessageSetTagFilterText::new);
    public String tagFilterText;
    public int entityId;

    public MessageSetTagFilterText(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageSetTagFilterText(String tagFilterText, int entityId) {
        this.tagFilterText = tagFilterText;
        this.entityId = entityId;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        Entity e = player.level().getEntity(this.entityId);
        if (e instanceof SpiritEntity) {
            SpiritEntity spirit = (SpiritEntity)e;
            spirit.setTagFilter(this.tagFilterText);
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeUtf(this.tagFilterText);
        buf.writeInt(this.entityId);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.tagFilterText = buf.readUtf(255);
        this.entityId = buf.readInt();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

