/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.handlers;

import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.BeaverFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.BeholderFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.FairyFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.GuardianFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.HeadlessFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.klikli_dev.occultism.common.item.tool.FamiliarRingItem;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismEffects;
import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.util.FamiliarUtil;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@EventBusSubscriber(modid="occultism", bus=EventBusSubscriber.Bus.GAME)
public class FamiliarEventHandler {
    @SubscribeEvent
    public static void beaverFindTree(BlockGrowFeatureEvent event) {
        LevelAccessor world = event.getLevel();
        BlockPos pos = event.getPos();
        List beavers = event.getLevel().getEntitiesOfClass(BeaverFamiliarEntity.class, new AABB(pos).inflate(30.0), b -> !b.isSitting() && b.isEffectEnabled(b.getFamiliarOwner()));
        if (!beavers.isEmpty()) {
            BeaverFamiliarEntity beaver = (BeaverFamiliarEntity)beavers.get(world.getRandom().nextInt(beavers.size()));
            beaver.setTreeTarget(pos);
        }
    }

    @SubscribeEvent
    public static void beaverHarvest(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (!event.getState().is(BlockTags.LOGS)) {
            return;
        }
        if (!player.hasEffect(OccultismEffects.BEAVER_HARVEST)) {
            return;
        }
        int level = player.getEffect(OccultismEffects.BEAVER_HARVEST).getAmplifier();
        event.setNewSpeed(event.getNewSpeed() * (float)(level + 3));
    }

    @SubscribeEvent
    public static void dodge(LivingIncomingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.hasEffect(OccultismEffects.MUMMY_DODGE)) {
            return;
        }
        DamageSource source = event.getSource();
        if (source.getEntity() == null | source.is(DamageTypeTags.IS_EXPLOSION) || source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return;
        }
        int level = entity.getEffect(OccultismEffects.MUMMY_DODGE).getAmplifier();
        boolean dodge = entity.getRandom().nextDouble() < (double)((float)(level + 1) * 0.1f);
        event.setCanceled(dodge);
        if (dodge) {
            ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(entity, FamiliarTrigger.Type.MUMMY_DODGE);
        }
    }

    @SubscribeEvent
    public static void livingDeathEvent(LivingDeathEvent event) {
        FamiliarEventHandler.guardianUltimateSacrifice(event);
        FamiliarEventHandler.headlessStealHead(event);
        FamiliarEventHandler.fairySave(event);
        FamiliarEventHandler.lifesteal(event);
    }

    private static void lifesteal(LivingDeathEvent event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        if (!attacker.hasEffect(OccultismEffects.BAT_LIFESTEAL)) {
            return;
        }
        attacker.heal((float)(1 + attacker.getEffect(OccultismEffects.BAT_LIFESTEAL).getAmplifier()));
    }

    private static void fairySave(LivingDeathEvent event) {
        IFamiliar familiar;
        LivingEntity entity;
        block7: {
            block6: {
                entity = event.getEntity();
                if (event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY) || !(entity instanceof IFamiliar)) break block6;
                familiar = (IFamiliar)entity;
                if (entity.getType() != OccultismEntities.GUARDIAN_FAMILIAR.get() && entity.getType() != OccultismEntities.FAIRY_FAMILIAR.get()) break block7;
            }
            return;
        }
        LivingEntity owner = familiar.getFamiliarOwner();
        if (owner == null || !FamiliarUtil.isFamiliarEnabled(owner, OccultismEntities.FAIRY_FAMILIAR.get())) {
            return;
        }
        FairyFamiliarEntity fairy = FamiliarUtil.getFamiliar(owner, OccultismEntities.FAIRY_FAMILIAR.get());
        if (fairy == null || !fairy.saveFamiliar(familiar)) {
            return;
        }
        event.setCanceled(true);
        entity.setHealth(2.0f);
        entity.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 2));
        if (!owner.level().isClientSide) {
            ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(owner, FamiliarTrigger.Type.FAIRY_SAVE);
        }
    }

    @SubscribeEvent
    public static void livingDamageEvent(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!FamiliarUtil.isFamiliarEnabled((LivingEntity)player, OccultismEntities.HEADLESS_FAMILIAR.get())) {
            return;
        }
        EntityType headType = event.getEntity().getType();
        if (!FamiliarUtil.hasFamiliar((LivingEntity)player, OccultismEntities.HEADLESS_FAMILIAR.get(), h -> h.getHeadType() == headType)) {
            return;
        }
        event.setAmount(event.getAmount() * 1.3f);
    }

    private static void headlessStealHead(LivingDeathEvent event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!FamiliarUtil.isFamiliarEnabled((LivingEntity)player, OccultismEntities.HEADLESS_FAMILIAR.get())) {
            return;
        }
        List<HeadlessFamiliarEntity> headlesses = FamiliarUtil.getAllFamiliars((LivingEntity)player, OccultismEntities.HEADLESS_FAMILIAR.get());
        if (!headlesses.isEmpty() && event.getEntity().getType() == OccultismEntities.CTHULHU_FAMILIAR.get()) {
            ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger((LivingEntity)player, FamiliarTrigger.Type.HEADLESS_CTHULHU_HEAD);
        }
        headlesses.forEach(h -> h.setHeadType(event.getEntity().getType()));
    }

    private static void guardianUltimateSacrifice(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY) || !((livingEntity = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!FamiliarUtil.isFamiliarEnabled((LivingEntity)player, OccultismEntities.GUARDIAN_FAMILIAR.get())) {
            return;
        }
        GuardianFamiliarEntity guardian = FamiliarUtil.getFamiliar((LivingEntity)player, OccultismEntities.GUARDIAN_FAMILIAR.get());
        if (guardian == null) {
            return;
        }
        if (!guardian.sacrifice()) {
            return;
        }
        ICuriosItemHandler handler = CuriosApi.getCuriosInventory((LivingEntity)event.getEntity()).orElse(null);
        if (handler == null) {
            return;
        }
        List equipped = handler.findCurios(itemStack -> itemStack.getItem() instanceof FamiliarRingItem);
        if (equipped != null) {
            equipped.forEach(ring -> {
                if (FamiliarRingItem.getFamiliar(ring.stack(), event.getEntity().level()) instanceof GuardianFamiliarEntity) {
                    CompoundTag familiarTag = new CompoundTag();
                    FamiliarRingItem.getFamiliar(ring.stack(), event.getEntity().level()).getFamiliarEntity().saveAsPassenger(familiarTag);
                    EntityType.loadEntityRecursive((CompoundTag)familiarTag, (Level)event.getEntity().level(), e -> {
                        e.setPos(player.getX(), player.getY(), player.getZ());
                        ((IFamiliar)e).setFamiliarOwner((LivingEntity)player);
                        String name = ItemNBTUtil.getBoundSpiritName(ring.stack());
                        e.setCustomName((Component)Component.literal((String)name));
                        event.getEntity().level().addFreshEntity(e);
                        ((GuardianFamiliarEntity)e).sacrifice();
                        ring.stack().shrink(1);
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)OccultismItems.FAMILIAR_RING.get()));
                        return e;
                    });
                }
            });
        }
        event.setCanceled(true);
        player.setHealth(1.0f);
        player.removeAllEffects();
        player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 1));
        player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
    }

    @SubscribeEvent
    public static void beholderBlindnessImmune(MobEffectEvent.Applicable event) {
        EntityType<BeholderFamiliarEntity> beholder;
        if (event.getEffectInstance().getEffect() != MobEffects.BLINDNESS) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!FamiliarUtil.hasFamiliar(entity, beholder = OccultismEntities.BEHOLDER_FAMILIAR.get(), FamiliarEntity::hasBlacksmithUpgrade)) {
            return;
        }
        event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
    }
}

