/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.tags;

import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class OccultismItemTagProvider
extends ItemTagsProvider {
    public OccultismItemTagProvider(PackOutput p_275343_, CompletableFuture<HolderLookup.Provider> p_275729_, CompletableFuture<TagsProvider.TagLookup<Block>> p_275322_, @Nullable ExistingFileHelper existingFileHelper) {
        super(p_275343_, p_275729_, p_275322_, "occultism", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.addCommonTags(provider);
        this.addMinecraftTags(provider);
        this.addOccultismTags(provider);
        this.addCuriosTags(provider);
        this.addOptionalOreTagsForMinerCompat(provider);
    }

    private void addOptionalOreTagsForMinerCompat(HolderLookup.Provider provider) {
        this.tag(this.cTag("ores/bone_fragments")).addOptional(this.loc("aoa3:bone_fragments_ore"));
        this.tag(this.cTag("ores/baronyte")).addOptional(this.loc("aoa3:baronyte_ore"));
        this.tag(this.cTag("ores/blazium")).addOptional(this.loc("aoa3:blazium_ore"));
        this.tag(this.cTag("ores/bloodstone")).addOptional(this.loc("aoa3:bloodstone_ore"));
        this.tag(this.cTag("ores/blue_gemstone")).addOptional(this.loc("aoa3:blue_gemstone_ore"));
        this.tag(this.cTag("ores/charged_runium")).addOptional(this.loc("aoa3:charged_runium_ore"));
        this.tag(this.cTag("ores/crystallite")).addOptional(this.loc("aoa3:crystallite_ore"));
        this.tag(this.cTag("ores/elecanium")).addOptional(this.loc("aoa3:elecanium_ore"));
        this.tag(this.cTag("ores/emberstone")).addOptional(this.loc("aoa3:emberstone_ore"));
        this.tag(this.cTag("ores/gemenyte")).addOptional(this.loc("aoa3:gemenyte_ore"));
        this.tag(this.cTag("ores/ghastly")).addOptional(this.loc("aoa3:ghastly_ore"));
        this.tag(this.cTag("ores/ghoulish")).addOptional(this.loc("aoa3:ghoulish_ore"));
        this.tag(this.cTag("ores/green_gemstone")).addOptional(this.loc("aoa3:green_gemstone_ore"));
        this.tag(this.cTag("ores/jade")).addOptional(this.loc("aoa3:jade_ore"));
        this.tag(this.cTag("ores/jewelyte")).addOptional(this.loc("aoa3:jewelyte_ore"));
        this.tag(this.cTag("ores/limonite")).addOptional(this.loc("aoa3:limonite_ore"));
        this.tag(this.cTag("ores/lyon")).addOptional(this.loc("aoa3:lyon_ore"));
        this.tag(this.cTag("ores/mystite")).addOptional(this.loc("aoa3:mystite_ore"));
        this.tag(this.cTag("ores/ornamyte")).addOptional(this.loc("aoa3:ornamyte_ore"));
        this.tag(this.cTag("ores/purple_gemstone")).addOptional(this.loc("aoa3:purple_gemstone_ore"));
        this.tag(this.cTag("ores/red_gemstone")).addOptional(this.loc("aoa3:red_gemstone_ore"));
        this.tag(this.cTag("ores/runium")).addOptional(this.loc("aoa3:runium_ore"));
        this.tag(this.cTag("ores/shyregem")).addOptional(this.loc("aoa3:shyregem_ore"));
        this.tag(this.cTag("ores/shyrestone")).addOptional(this.loc("aoa3:shyrestone_ore"));
        this.tag(this.cTag("ores/varsium")).addOptional(this.loc("aoa3:varsium_ore"));
        this.tag(this.cTag("ores/white_gemstone")).addOptional(this.loc("aoa3:white_gemstone_ore"));
        this.tag(this.cTag("ores/yellow_gemstone")).addOptional(this.loc("aoa3:yellow_gemstone_ore"));
        this.tag(this.cTag("ores/dark_gem")).addOptional(this.loc("evilcraft:dark_ores")).addOptionalTag(this.loc("evilcraft:ores/dark_gem"));
        this.tag(this.cTag("dusts/dark_gem")).addOptional(this.loc("evilcraft:dark_gem_crushed"));
        this.tag(this.cTag("ores/black_quartz")).addOptional(this.loc("actuallyadditions:black_quartz_ore"));
        this.tag(this.cTag("gems/black_quartz")).addOptional(this.loc("actuallyadditions:black_quartz"));
        this.tag(this.cTag("dusts/certus_quartz")).addOptional(this.loc("ae2:certus_quartz_dust"));
        this.tag(this.cTag("dusts/fluix")).addOptional(this.loc("ae2:fluix_dust"));
        this.tag(this.cTag("dusts/sky_stone")).addOptional(this.loc("ae2:sky_dust"));
        this.tag(this.cTag("sky_stones")).addOptional(this.loc("ae2:sky_stone_block")).addOptional(this.loc("ae2:smooth_sky_stone_block")).addOptional(this.loc("ae2:sky_stone_brick")).addOptional(this.loc("ae2:sky_stone_small_brick"));
    }

    private void addCuriosTags(HolderLookup.Provider provider) {
        this.tag(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"belt"))).add((Object)((Item)OccultismItems.SATCHEL.get())).replace(false);
        this.tag(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"hands"))).add((Object)((Item)OccultismItems.STORAGE_REMOTE.get())).replace(false);
        this.tag(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"head"))).add((Object)((Item)OccultismItems.OTHERWORLD_GOGGLES.get())).replace(false);
        this.tag(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"ring"))).add((Object)((Item)OccultismItems.FAMILIAR_RING.get())).replace(false);
    }

    private void addOccultismTags(HolderLookup.Provider provider) {
        this.copy(OccultismTags.Blocks.OCCULTISM_CANDLES, OccultismTags.Items.OCCULTISM_CANDLES);
        this.copy(BlockTags.CANDLES, ItemTags.CANDLES);
        this.tag(OccultismTags.Items.SKULLS).add((Object)Items.SKELETON_SKULL).add((Object)Items.WITHER_SKELETON_SKULL).replace(false);
        this.tag(OccultismTags.Items.SCUTESHELL).add((Object)Items.ARMADILLO_SCUTE).add((Object)Items.TURTLE_SCUTE).add((Object)Items.SHULKER_SHELL).add((Object)Items.NAUTILUS_SHELL).replace(false);
        this.copy(OccultismTags.Blocks.PENTACLE_MATERIALS, OccultismTags.Items.PENTACLE_MATERIALS);
        this.tag(OccultismTags.Items.PENTACLE_MATERIALS).addOptionalTag(OccultismTags.Items.TOOLS_CHALK).replace(false);
        this.tag(OccultismTags.Items.DEMONIC_PARTNER_FOOD).addTag(ItemTags.MEAT);
        this.tag(OccultismTags.Items.BOOK_OF_CALLING_FOLIOT).add((Object)((Item)OccultismItems.BOOK_OF_CALLING_FOLIOT_LUMBERJACK.get())).add((Object)((Item)OccultismItems.BOOK_OF_CALLING_FOLIOT_CLEANER.get())).add((Object)((Item)OccultismItems.BOOK_OF_CALLING_FOLIOT_TRANSPORT_ITEMS.get())).replace(false);
        this.tag(OccultismTags.Items.BOOK_OF_CALLING_DJINNI).add((Object)((Item)OccultismItems.BOOK_OF_CALLING_DJINNI_MANAGE_MACHINE.get())).replace(false);
        this.tag(OccultismTags.Items.BOOKS_OF_BINDING).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_FOLIOT.get())).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_DJINNI.get())).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_AFRIT.get())).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_MARID.get()));
        this.tag(OccultismTags.Items.Miners.BASIC_RESOURCES).add((Object[])new Item[]{(Item)OccultismItems.MINER_FOLIOT_UNSPECIALIZED.get(), (Item)OccultismItems.MINER_DEBUG_UNSPECIALIZED.get()}).replace(false);
        this.tag(OccultismTags.Items.Miners.DEEPS).add((Object[])new Item[]{(Item)OccultismItems.MINER_AFRIT_DEEPS.get(), (Item)OccultismItems.MINER_MARID_MASTER.get()}).replace(false);
        this.tag(OccultismTags.Items.Miners.MASTER).add((Object)((Item)OccultismItems.MINER_MARID_MASTER.get())).replace(false);
        this.tag(OccultismTags.Items.Miners.ORES).add((Object[])new Item[]{(Item)OccultismItems.MINER_FOLIOT_UNSPECIALIZED.get(), (Item)OccultismItems.MINER_DEBUG_UNSPECIALIZED.get(), (Item)OccultismItems.MINER_AFRIT_DEEPS.get(), (Item)OccultismItems.MINER_MARID_MASTER.get(), (Item)OccultismItems.MINER_DJINNI_ORES.get()}).replace(false);
        this.tag(OccultismTags.Items.Miners.ELDRITCH).add((Object)((Item)OccultismItems.MINER_ANCIENT_ELDRITCH.get())).replace(false);
        this.tag(OccultismTags.Items.Miners.MINERS).addTag(OccultismTags.Items.Miners.BASIC_RESOURCES).addTag(OccultismTags.Items.Miners.DEEPS).addTag(OccultismTags.Items.Miners.MASTER).addTag(OccultismTags.Items.Miners.ORES).addTag(OccultismTags.Items.Miners.ELDRITCH).replace(false);
        this.tag(OccultismTags.Items.TOOLS_CHALK).add((Object)((Item)OccultismItems.CHALK_YELLOW.get())).add((Object)((Item)OccultismItems.CHALK_WHITE.get())).add((Object)((Item)OccultismItems.CHALK_RED.get())).add((Object)((Item)OccultismItems.CHALK_PURPLE.get())).add((Object)((Item)OccultismItems.CHALK_LIGHT_GRAY.get())).add((Object)((Item)OccultismItems.CHALK_GRAY.get())).add((Object)((Item)OccultismItems.CHALK_BLACK.get())).add((Object)((Item)OccultismItems.CHALK_BROWN.get())).add((Object)((Item)OccultismItems.CHALK_ORANGE.get())).add((Object)((Item)OccultismItems.CHALK_LIME.get())).add((Object)((Item)OccultismItems.CHALK_GREEN.get())).add((Object)((Item)OccultismItems.CHALK_CYAN.get())).add((Object)((Item)OccultismItems.CHALK_LIGHT_BLUE.get())).add((Object)((Item)OccultismItems.CHALK_BLUE.get())).add((Object)((Item)OccultismItems.CHALK_MAGENTA.get())).add((Object)((Item)OccultismItems.CHALK_PINK.get())).add((Object)((Item)OccultismItems.CHALK_RAINBOW.get())).add((Object)((Item)OccultismItems.CHALK_VOID.get())).replace(false);
        this.copy(OccultismTags.Blocks.OTHERWORLD_SAPLINGS, OccultismTags.Items.OTHERWORLD_SAPLINGS);
        this.copy(OccultismTags.Blocks.OTHERWORLD_SAPLINGS_NATURAL, OccultismTags.Items.OTHERWORLD_SAPLINGS_NATURAL);
        this.tag(OccultismTags.Items.TOOLS_KNIFE).add((Object)((Item)OccultismItems.BUTCHER_KNIFE.get())).replace(false);
        this.tag(Tags.Items.TOOLS).addOptionalTag(OccultismTags.Items.TOOLS_KNIFE).replace(false);
        this.tag(OccultismTags.Items.ELYTRA).add((Object)Items.ELYTRA).addOptional(ResourceLocation.fromNamespaceAndPath((String)"mana-and-artifice", (String)"spectral_elytra")).replace(false);
        this.tag(OccultismTags.Items.OTHERWORLD_GOGGLES).add((Object)((Item)OccultismItems.OTHERWORLD_GOGGLES.get())).replace(false);
        this.tag(OccultismTags.Items.OTHERSTONE).add((Object)OccultismBlocks.OTHERSTONE.asItem());
        this.tag(OccultismTags.Items.OTHERCOBBLESTONE).add((Object)OccultismBlocks.OTHERCOBBLESTONE.asItem());
    }

    private void addMinecraftTags(HolderLookup.Provider provider) {
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)((Item)OccultismItems.DICTIONARY_OF_SPIRITS.get()));
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_AFRIT.get()));
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()));
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_DJINNI.get()));
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()));
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_FOLIOT.get()));
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()));
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_MARID.get()));
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()));
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)((Item)OccultismItems.BOOK_OF_CALLING_DJINNI_MANAGE_MACHINE.get()));
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)((Item)OccultismItems.BOOK_OF_CALLING_FOLIOT_CLEANER.get()));
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)((Item)OccultismItems.BOOK_OF_CALLING_FOLIOT_LUMBERJACK.get()));
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)((Item)OccultismItems.BOOK_OF_CALLING_FOLIOT_TRANSPORT_ITEMS.get()));
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_EMPTY.get()));
        this.tag(ItemTags.DURABILITY_ENCHANTABLE).addTag(OccultismTags.Items.Miners.MINERS);
        this.tag(ItemTags.DURABILITY_ENCHANTABLE).addTag(OccultismTags.Items.TOOLS_CHALK);
        this.tag(ItemTags.DURABILITY_ENCHANTABLE).addTag(OccultismTags.Items.TOOLS_KNIFE);
        this.tag(ItemTags.SHARP_WEAPON_ENCHANTABLE).addTag(OccultismTags.Items.TOOLS_KNIFE);
        this.tag(ItemTags.SWORD_ENCHANTABLE).addTag(OccultismTags.Items.TOOLS_KNIFE);
        this.tag(ItemTags.LOGS_THAT_BURN).add((Object)OccultismBlocks.OTHERWORLD_LOG.asItem()).add((Object)OccultismBlocks.OTHERWORLD_LOG_NATURAL.asItem()).add((Object)OccultismBlocks.STRIPPED_OTHERWORLD_LOG_NATURAL.asItem()).add((Object)OccultismBlocks.OTHERWORLD_WOOD.asItem()).add((Object)OccultismBlocks.STRIPPED_OTHERWORLD_LOG.asItem()).add((Object)OccultismBlocks.STRIPPED_OTHERWORLD_WOOD.asItem());
        this.tag(ItemTags.PLANKS).add((Object)OccultismBlocks.OTHERPLANKS.asItem());
        this.tag(ItemTags.WOODEN_STAIRS).add((Object)OccultismBlocks.OTHERPLANKS_STAIRS.asItem());
        this.tag(ItemTags.WOODEN_SLABS).add((Object)OccultismBlocks.OTHERPLANKS_SLAB.asItem());
        this.tag(ItemTags.WOODEN_FENCES).add((Object)OccultismBlocks.OTHERPLANKS_FENCE.asItem()).replace(false);
        this.tag(ItemTags.FENCE_GATES).add((Object)OccultismBlocks.OTHERPLANKS_FENCE_GATE.asItem()).replace(false);
        this.tag(ItemTags.WOODEN_DOORS).add((Object)OccultismBlocks.OTHERPLANKS_DOOR.asItem()).replace(false);
        this.tag(ItemTags.WOODEN_TRAPDOORS).add((Object)OccultismBlocks.OTHERPLANKS_TRAPDOOR.asItem()).replace(false);
        this.tag(ItemTags.WOODEN_PRESSURE_PLATES).add((Object)OccultismBlocks.OTHERPLANKS_PRESSURE_PLATE.asItem()).replace(false);
        this.tag(ItemTags.WOODEN_BUTTONS).add((Object)OccultismBlocks.OTHERPLANKS_BUTTON.asItem()).replace(false);
        this.tag(ItemTags.SIGNS).add((Object)((Item)OccultismItems.OTHERPLANKS_SIGN.get())).replace(false);
        this.tag(ItemTags.HANGING_SIGNS).add((Object)((Item)OccultismItems.OTHERPLANKS_HANGING_SIGN.get())).replace(false);
        this.tag(ItemTags.STAIRS).add((Object)OccultismBlocks.OTHERSTONE_STAIRS.asItem()).add((Object)OccultismBlocks.OTHERCOBBLESTONE_STAIRS.asItem()).add((Object)OccultismBlocks.POLISHED_OTHERSTONE_STAIRS.asItem()).add((Object)OccultismBlocks.OTHERSTONE_BRICKS_STAIRS.asItem());
        this.tag(ItemTags.WALLS).add((Object)OccultismBlocks.OTHERSTONE_WALL.asItem()).add((Object)OccultismBlocks.OTHERCOBBLESTONE_WALL.asItem()).add((Object)OccultismBlocks.POLISHED_OTHERSTONE_WALL.asItem()).add((Object)OccultismBlocks.OTHERSTONE_BRICKS_WALL.asItem());
        this.tag(ItemTags.STONE_BUTTONS).add((Object)OccultismBlocks.OTHERSTONE_BUTTON.asItem());
        this.tag(ItemTags.CLUSTER_MAX_HARVESTABLES).add((Object[])new Item[]{(Item)OccultismItems.INFUSED_PICKAXE.get(), (Item)OccultismItems.IESNIUM_PICKAXE.get()}).replace(false);
        this.copy(BlockTags.LEAVES, ItemTags.LEAVES);
        this.copy(BlockTags.LOGS, ItemTags.LOGS);
        this.copy(BlockTags.PIGLIN_REPELLENTS, ItemTags.PIGLIN_REPELLENTS);
        this.copy(BlockTags.SAPLINGS, ItemTags.SAPLINGS);
        this.tag(ItemTags.PICKAXES).add((Object[])new Item[]{(Item)OccultismItems.INFUSED_PICKAXE.get(), (Item)OccultismItems.IESNIUM_PICKAXE.get()}).replace(false);
        this.tag(this.cTag("tools/knife")).add((Object)((Item)OccultismItems.BUTCHER_KNIFE.get())).replace(false);
        this.tag(ItemTags.BOOKSHELF_BOOKS).replace(false).add((Object)((Item)OccultismItems.DICTIONARY_OF_SPIRITS.get())).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_FOLIOT.get())).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_DJINNI.get())).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_AFRIT.get())).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_MARID.get())).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get())).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get())).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get())).add((Object)((Item)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get())).add((Object)((Item)OccultismItems.BOOK_OF_CALLING_DJINNI_MANAGE_MACHINE.get())).add((Object)((Item)OccultismItems.BOOK_OF_CALLING_FOLIOT_CLEANER.get())).add((Object)((Item)OccultismItems.BOOK_OF_CALLING_FOLIOT_LUMBERJACK.get())).add((Object)((Item)OccultismItems.BOOK_OF_CALLING_FOLIOT_TRANSPORT_ITEMS.get()));
        this.tag(ItemTags.SMALL_FLOWERS).add((Object)OccultismBlocks.OTHERFLOWER.asItem()).add((Object)OccultismBlocks.OTHERFLOWER_NATURAL.asItem()).replace(false);
    }

    private void addCommonTags(HolderLookup.Provider provider) {
        this.tag(Tags.Items.MINING_TOOL_TOOLS).add((Object)((Item)OccultismItems.INFUSED_PICKAXE.get())).add((Object)((Item)OccultismItems.IESNIUM_PICKAXE.get())).replace(false);
        this.copy(BlockTags.SLABS, ItemTags.SLABS);
        this.copy(OccultismTags.Blocks.IESNIUM_ORE, OccultismTags.Items.IESNIUM_ORE);
        this.copy(OccultismTags.Blocks.SILVER_ORE, OccultismTags.Items.SILVER_ORE);
        this.tag(Tags.Items.ORES).addTags(new TagKey[]{OccultismTags.Items.IESNIUM_ORE, OccultismTags.Items.SILVER_ORE}).replace(false);
        this.copy(Tags.Blocks.ORES_IN_GROUND_STONE, Tags.Items.ORES_IN_GROUND_STONE);
        this.copy(Tags.Blocks.ORES_IN_GROUND_DEEPSLATE, Tags.Items.ORES_IN_GROUND_DEEPSLATE);
        this.copy(Tags.Blocks.ORES_IN_GROUND_NETHERRACK, Tags.Items.ORES_IN_GROUND_NETHERRACK);
        this.tag(OccultismTags.Items.RAW_SILVER).add((Object)((Item)OccultismItems.RAW_SILVER.get())).replace(false);
        this.tag(OccultismTags.Items.RAW_IESNIUM).add((Object)((Item)OccultismItems.RAW_IESNIUM.get())).replace(false);
        this.tag(Tags.Items.RAW_MATERIALS).addTags(new TagKey[]{OccultismTags.Items.RAW_IESNIUM, OccultismTags.Items.RAW_SILVER}).replace(false);
        this.addDusts(provider);
        this.tag(OccultismTags.Items.DATURA_CROP).add((Object)((Item)OccultismItems.DATURA.get())).replace(false);
        this.tag(Tags.Items.CROPS).addTags(new TagKey[]{OccultismTags.Items.DATURA_CROP}).replace(false);
        this.tag(OccultismTags.Items.IESNIUM_INGOT).add((Object)((Item)OccultismItems.IESNIUM_INGOT.get())).replace(false);
        this.tag(OccultismTags.Items.SILVER_INGOT).add((Object)((Item)OccultismItems.SILVER_INGOT.get())).replace(false);
        this.tag(Tags.Items.INGOTS).addTags(new TagKey[]{OccultismTags.Items.IESNIUM_INGOT, OccultismTags.Items.SILVER_INGOT}).replace(false);
        this.tag(OccultismTags.Items.IESNIUM_NUGGET).add((Object)((Item)OccultismItems.IESNIUM_NUGGET.get())).replace(false);
        this.tag(OccultismTags.Items.SILVER_NUGGET).add((Object)((Item)OccultismItems.SILVER_NUGGET.get())).replace(false);
        this.tag(Tags.Items.NUGGETS).addTags(new TagKey[]{OccultismTags.Items.IESNIUM_NUGGET, OccultismTags.Items.SILVER_NUGGET}).replace(false);
        this.tag(OccultismTags.Items.DATURA_SEEDS).add((Object)((Item)OccultismItems.DATURA_SEEDS.get())).replace(false);
        this.tag(Tags.Items.SEEDS).addTags(new TagKey[]{OccultismTags.Items.DATURA_SEEDS}).replace(false);
        this.tag(Tags.Items.FOODS).add((Object)((Item)OccultismItems.DATURA.get())).add((Object)((Item)OccultismItems.DEMONS_DREAM_ESSENCE.get())).add((Object)((Item)OccultismItems.OTHERWORLD_ESSENCE.get())).add((Object)((Item)OccultismItems.BEAVER_NUGGET.get())).add((Object)((Item)OccultismItems.CURSED_HONEY.get())).add((Object)((Item)OccultismItems.DEMONIC_MEAT.get())).replace(false);
        this.tag(ItemTags.MEAT).add((Object)((Item)OccultismItems.DEMONIC_MEAT.get())).replace(false);
        this.copy(OccultismTags.Blocks.STORAGE_BLOCKS_IESNIUM, OccultismTags.Items.STORAGE_BLOCK_IESNIUM);
        this.copy(OccultismTags.Blocks.STORAGE_BLOCKS_SILVER, OccultismTags.Items.STORAGE_BLOCK_SILVER);
        this.copy(OccultismTags.Blocks.STORAGE_BLOCKS_RAW_IESNIUM, OccultismTags.Items.STORAGE_BLOCK_RAW_IESNIUM);
        this.copy(OccultismTags.Blocks.STORAGE_BLOCKS_RAW_SILVER, OccultismTags.Items.STORAGE_BLOCK_RAW_SILVER);
        this.tag(Tags.Items.STORAGE_BLOCKS).addTags(new TagKey[]{OccultismTags.Items.STORAGE_BLOCK_IESNIUM, OccultismTags.Items.STORAGE_BLOCK_SILVER, OccultismTags.Items.STORAGE_BLOCK_RAW_IESNIUM, OccultismTags.Items.STORAGE_BLOCK_RAW_SILVER}).replace(false);
        this.copy(OccultismTags.Blocks.MUSHROOM_BLOCKS, OccultismTags.Items.MUSHROOM_BLOCKS);
        this.tag(OccultismTags.Items.METAL_AXES).add((Object[])new Item[]{Items.IRON_AXE, Items.GOLDEN_AXE, Items.DIAMOND_AXE, Items.NETHERITE_AXE}).replace(false);
        this.tag(OccultismTags.Items.BOOKS).add((Object[])new Item[]{(Item)OccultismItems.DICTIONARY_OF_SPIRITS.get(), Items.BOOK}).replace(false);
        this.tag(OccultismTags.Items.FRUITS).add((Object)Items.APPLE).replace(false);
        this.tag(Tags.Items.GEMS).add((Object)((Item)OccultismItems.SPIRIT_ATTUNED_GEM.get())).replace(false);
        this.tag(OccultismTags.Items.MAGMA).add((Object)Items.MAGMA_BLOCK).replace(false);
        this.tag(OccultismTags.Items.MANUALS).add((Object)((Item)OccultismItems.DICTIONARY_OF_SPIRITS.get())).replace(false);
        this.tag(OccultismTags.Items.TALLOW).add((Object)((Item)OccultismItems.TALLOW.get())).replace(false);
        this.copy(OccultismTags.Blocks.OTHERWORLD_LOGS, OccultismTags.Items.OTHERWORLD_LOGS);
    }

    private void addDusts(HolderLookup.Provider provider) {
        this.tag(OccultismTags.Items.BLAZE_DUST).add((Object)Items.BLAZE_POWDER).replace(false);
        this.tag(OccultismTags.Items.COPPER_DUST).add((Object)((Item)OccultismItems.COPPER_DUST.get())).replace(false);
        this.tag(OccultismTags.Items.END_STONE_DUST).add((Object)((Item)OccultismItems.CRUSHED_END_STONE.get())).replace(false);
        this.tag(OccultismTags.Items.GOLD_DUST).add((Object)((Item)OccultismItems.GOLD_DUST.get())).replace(false);
        this.tag(OccultismTags.Items.IRON_DUST).add((Object)((Item)OccultismItems.IRON_DUST.get())).replace(false);
        this.tag(OccultismTags.Items.IESNIUM_DUST).add((Object)((Item)OccultismItems.IESNIUM_DUST.get())).replace(false);
        this.tag(OccultismTags.Items.SILVER_DUST).add((Object)((Item)OccultismItems.SILVER_DUST.get())).replace(false);
        this.tag(OccultismTags.Items.OBSIDIAN_DUST).add((Object)((Item)OccultismItems.OBSIDIAN_DUST.get())).replace(false);
        this.tag(OccultismTags.Items.AMETHYST_DUST).add((Object)((Item)OccultismItems.AMETHYST_DUST.get())).replace(false);
        this.tag(OccultismTags.Items.BLACKSTONE_DUST).add((Object)((Item)OccultismItems.CRUSHED_BLACKSTONE.get())).replace(false);
        this.tag(OccultismTags.Items.BLUE_ICE_DUST).add((Object)((Item)OccultismItems.CRUSHED_BLUE_ICE.get())).replace(false);
        this.tag(OccultismTags.Items.CALCITE_DUST).add((Object)((Item)OccultismItems.CRUSHED_CALCITE.get())).replace(false);
        this.tag(OccultismTags.Items.ICE_DUST).add((Object)((Item)OccultismItems.CRUSHED_ICE.get())).replace(false);
        this.tag(OccultismTags.Items.PACKED_ICE_DUST).add((Object)((Item)OccultismItems.CRUSHED_PACKED_ICE.get())).replace(false);
        this.tag(OccultismTags.Items.DRAGONYST_DUST).add((Object)((Item)OccultismItems.DRAGONYST_DUST.get())).replace(false);
        this.tag(OccultismTags.Items.ECHO_DUST).add((Object)((Item)OccultismItems.ECHO_DUST.get())).replace(false);
        this.tag(OccultismTags.Items.EMERALD_DUST).add((Object)((Item)OccultismItems.EMERALD_DUST.get())).replace(false);
        this.tag(OccultismTags.Items.LAPIS_DUST).add((Object)((Item)OccultismItems.LAPIS_DUST.get())).replace(false);
        this.tag(OccultismTags.Items.NETHERITE_DUST).add((Object)((Item)OccultismItems.NETHERITE_DUST.get())).replace(false);
        this.tag(OccultismTags.Items.NETHERITE_SCRAP_DUST).add((Object)((Item)OccultismItems.NETHERITE_SCRAP_DUST.get())).replace(false);
        this.tag(OccultismTags.Items.RESEARCH_DUST).add((Object)((Item)OccultismItems.RESEARCH_FRAGMENT_DUST.get())).replace(false);
        this.tag(OccultismTags.Items.WITHERITE_DUST).add((Object)((Item)OccultismItems.WITHERITE_DUST.get())).replace(false);
        this.tag(OccultismTags.Items.OTHERSTONE_DUST).add((Object)((Item)OccultismItems.BURNT_OTHERSTONE.get())).replace(false);
        this.tag(OccultismTags.Items.OTHERWORLD_WOOD_DUST).add((Object)((Item)OccultismItems.OTHERWORLD_ASHES.get())).replace(false);
        this.tag(Tags.Items.DUSTS).addTags(new TagKey[]{OccultismTags.Items.COPPER_DUST, OccultismTags.Items.END_STONE_DUST, OccultismTags.Items.GOLD_DUST, OccultismTags.Items.IRON_DUST, OccultismTags.Items.IESNIUM_DUST, OccultismTags.Items.SILVER_DUST, OccultismTags.Items.OBSIDIAN_DUST, OccultismTags.Items.AMETHYST_DUST, OccultismTags.Items.BLACKSTONE_DUST, OccultismTags.Items.BLUE_ICE_DUST, OccultismTags.Items.CALCITE_DUST, OccultismTags.Items.ICE_DUST, OccultismTags.Items.PACKED_ICE_DUST, OccultismTags.Items.DRAGONYST_DUST, OccultismTags.Items.ECHO_DUST, OccultismTags.Items.EMERALD_DUST, OccultismTags.Items.LAPIS_DUST, OccultismTags.Items.NETHERITE_DUST, OccultismTags.Items.NETHERITE_SCRAP_DUST, OccultismTags.Items.RESEARCH_DUST, OccultismTags.Items.WITHERITE_DUST, OccultismTags.Items.OTHERSTONE_DUST, OccultismTags.Items.OTHERWORLD_WOOD_DUST});
    }

    private TagKey<Item> cTag(String path) {
        return ItemTags.create((ResourceLocation)this.cLoc(path));
    }

    private ResourceLocation cLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"c", (String)path);
    }

    private ResourceLocation loc(String namespaceAndPath) {
        return ResourceLocation.tryParse((String)namespaceAndPath);
    }
}

