/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen;

import com.klikli_dev.occultism.common.block.ChalkGlyphBlock;
import com.klikli_dev.occultism.common.block.RainbowGlyphBlock;
import com.klikli_dev.occultism.common.block.storage.StableWormholeBlock;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class StandardBlockStateProvider
extends BlockStateProvider {
    public StandardBlockStateProvider(PackOutput gen, ExistingFileHelper exFileHelper) {
        super(gen, "occultism", exFileHelper);
    }

    protected void registerStatesAndModels() {
        OccultismBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).filter(block -> block instanceof ChalkGlyphBlock).forEach(this::generateGlyphBlockState);
        OccultismBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).filter(block -> block instanceof RainbowGlyphBlock).forEach(this::generateRainbowGlyphBlockState);
        this.simpleBlock((Block)OccultismBlocks.STORAGE_CONTROLLER.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_controller")));
        this.models().withExistingParent("item/storage_controller", this.modLoc("block/storage_controller"));
        this.simpleBlock((Block)OccultismBlocks.STORAGE_CONTROLLER_BASE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_controller_base")));
        this.models().withExistingParent("item/storage_controller_base", this.modLoc("block/storage_controller_base"));
        this.simpleBlock((Block)OccultismBlocks.STORAGE_CONTROLLER_STABILIZED.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_controller_stabilized")));
        this.models().withExistingParent("item/storage_controller_stabilized", this.modLoc("block/storage_controller_stabilized"));
        this.generateStableWormholeState((Block)OccultismBlocks.STABLE_WORMHOLE.get());
        this.directionalBlock((Block)OccultismBlocks.SACRIFICIAL_BOWL.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/sacrificial_bowl")));
        this.directionalBlock((Block)OccultismBlocks.COPPER_SACRIFICIAL_BOWL.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/copper_sacrificial_bowl")));
        this.directionalBlock((Block)OccultismBlocks.SILVER_SACRIFICIAL_BOWL.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/silver_sacrificial_bowl")));
        this.directionalBlock((Block)OccultismBlocks.STORAGE_STABILIZER_TIER0.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_stabilizer_tier0")));
        this.directionalBlock((Block)OccultismBlocks.STORAGE_STABILIZER_TIER1.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_stabilizer_tier1")));
        this.directionalBlock((Block)OccultismBlocks.STORAGE_STABILIZER_TIER2.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_stabilizer_tier2")));
        this.directionalBlock((Block)OccultismBlocks.STORAGE_STABILIZER_TIER3.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_stabilizer_tier3")));
        this.directionalBlock((Block)OccultismBlocks.STORAGE_STABILIZER_TIER4.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_stabilizer_tier4")));
        this.stairsBlock((StairBlock)OccultismBlocks.OTHERPLANKS_STAIRS.get(), this.blockTexture((Block)OccultismBlocks.OTHERPLANKS.get()));
        this.fenceBlock((FenceBlock)OccultismBlocks.OTHERPLANKS_FENCE.get(), this.blockTexture((Block)OccultismBlocks.OTHERPLANKS.get()));
        this.fenceGateBlock((FenceGateBlock)OccultismBlocks.OTHERPLANKS_FENCE_GATE.get(), this.blockTexture((Block)OccultismBlocks.OTHERPLANKS.get()));
        this.doorBlockWithRenderType((DoorBlock)OccultismBlocks.OTHERPLANKS_DOOR.get(), this.modLoc("block/otherplanks_door_bottom"), this.modLoc("block/otherplanks_door_top"), "cutout");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)OccultismBlocks.OTHERPLANKS_TRAPDOOR.get(), this.modLoc("block/otherplanks_trapdoor"), true, "cutout");
        this.pressurePlateBlock((PressurePlateBlock)OccultismBlocks.OTHERPLANKS_PRESSURE_PLATE.get(), this.blockTexture((Block)OccultismBlocks.OTHERPLANKS.get()));
        this.buttonBlock((ButtonBlock)OccultismBlocks.OTHERPLANKS_BUTTON.get(), this.blockTexture((Block)OccultismBlocks.OTHERPLANKS.get()));
        this.stairsBlock((StairBlock)OccultismBlocks.OTHERSTONE_STAIRS.get(), this.blockTexture((Block)OccultismBlocks.OTHERSTONE.get()));
        this.wallBlock((WallBlock)OccultismBlocks.OTHERSTONE_WALL.get(), this.blockTexture((Block)OccultismBlocks.OTHERSTONE.get()));
        this.pressurePlateBlock((PressurePlateBlock)OccultismBlocks.OTHERSTONE_PRESSURE_PLATE.get(), this.blockTexture((Block)OccultismBlocks.OTHERSTONE.get()));
        this.buttonBlock((ButtonBlock)OccultismBlocks.OTHERSTONE_BUTTON.get(), this.blockTexture((Block)OccultismBlocks.OTHERSTONE.get()));
        this.stairsBlock((StairBlock)OccultismBlocks.OTHERCOBBLESTONE_STAIRS.get(), this.blockTexture((Block)OccultismBlocks.OTHERCOBBLESTONE.get()));
        this.slabBlock((SlabBlock)OccultismBlocks.OTHERCOBBLESTONE_SLAB.get(), this.blockTexture((Block)OccultismBlocks.OTHERCOBBLESTONE.get()), this.blockTexture((Block)OccultismBlocks.OTHERCOBBLESTONE.get()));
        this.wallBlock((WallBlock)OccultismBlocks.OTHERCOBBLESTONE_WALL.get(), this.blockTexture((Block)OccultismBlocks.OTHERCOBBLESTONE.get()));
        this.stairsBlock((StairBlock)OccultismBlocks.POLISHED_OTHERSTONE_STAIRS.get(), this.blockTexture((Block)OccultismBlocks.POLISHED_OTHERSTONE.get()));
        this.slabBlock((SlabBlock)OccultismBlocks.POLISHED_OTHERSTONE_SLAB.get(), this.blockTexture((Block)OccultismBlocks.POLISHED_OTHERSTONE.get()), this.blockTexture((Block)OccultismBlocks.POLISHED_OTHERSTONE.get()));
        this.wallBlock((WallBlock)OccultismBlocks.POLISHED_OTHERSTONE_WALL.get(), this.blockTexture((Block)OccultismBlocks.POLISHED_OTHERSTONE.get()));
        this.stairsBlock((StairBlock)OccultismBlocks.OTHERSTONE_BRICKS_STAIRS.get(), this.blockTexture((Block)OccultismBlocks.OTHERSTONE_BRICKS.get()));
        this.slabBlock((SlabBlock)OccultismBlocks.OTHERSTONE_BRICKS_SLAB.get(), this.blockTexture((Block)OccultismBlocks.OTHERSTONE_BRICKS.get()), this.blockTexture((Block)OccultismBlocks.OTHERSTONE_BRICKS.get()));
        this.wallBlock((WallBlock)OccultismBlocks.OTHERSTONE_BRICKS_WALL.get(), this.blockTexture((Block)OccultismBlocks.OTHERSTONE_BRICKS.get()));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_WHITE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_white")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_LIGHT_GRAY.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_light_gray")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_GRAY.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_gray")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_BLACK.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_black")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_BROWN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_brown")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_RED.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_red")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_ORANGE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_orange")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_YELLOW.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_yellow")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_LIME.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_lime")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_GREEN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_green")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_CYAN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_cyan")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_BLUE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_blue")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_LIGHT_BLUE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_light_blue")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_PINK.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_pink")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_MAGENTA.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_magenta")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_PURPLE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_purple")));
    }

    protected void generateStableWormholeState(Block block) {
        ModelFile.ExistingModelFile linkedModel = this.models().getExistingFile(this.modLoc("block/stable_wormhole"));
        ModelFile.ExistingModelFile unlinkedModel = this.models().getExistingFile(this.modLoc("block/stable_wormhole_unlinked"));
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.getValue(StableWormholeBlock.LINKED) != false ? linkedModel : unlinkedModel)).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + 180) % 360).build();
        });
    }

    protected void generateGlyphBlockState(Block block) {
        ModelFile.ExistingModelFile parent = this.models().getExistingFile(this.modLoc("block/chalk_glyph/chalk_glyph"));
        this.getVariantBuilder(block).forAllStates(state -> {
            int sign = (Integer)state.getValue((Property)ChalkGlyphBlock.SIGN);
            ModelBuilder subModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/chalk_glyph/" + sign)).parent((ModelFile)parent)).texture("texture", this.modLoc("block/chalk_glyph/" + sign));
            return ConfiguredModel.builder().modelFile((ModelFile)subModel).rotationY((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot()).build();
        });
    }

    protected void generateRainbowGlyphBlockState(Block block) {
        ModelFile.ExistingModelFile parent = this.models().getExistingFile(this.modLoc("block/chalk_glyph/chalk_glyph"));
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int sign = (Integer)state.getValue((Property)RainbowGlyphBlock.SIGN);
            ModelBuilder subModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/chalk_glyph/" + sign)).parent((ModelFile)parent)).texture("texture", this.modLoc("block/chalk_glyph/" + sign));
            return ConfiguredModel.builder().modelFile((ModelFile)subModel).rotationY((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot()).build();
        }, new Property[]{RainbowGlyphBlock.COLOR});
    }
}

