/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block;

import com.klikli_dev.occultism.common.blockentity.GoldenSacrificialBowlBlockEntity;
import com.klikli_dev.occultism.registry.OccultismBlockEntities;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.util.StorageUtil;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GoldenSacrificialBowlBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.3, (double)12.0);
    private static final VoxelShape SHAPE_TROPHY = Stream.of(Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0), Block.box((double)5.0, (double)0.0, (double)7.0, (double)11.0, (double)1.0, (double)9.0), Block.box((double)7.0, (double)0.0, (double)5.0, (double)9.0, (double)1.0, (double)11.0), Block.box((double)7.5, (double)1.0, (double)7.5, (double)8.5, (double)6.0, (double)8.5), Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)7.0, (double)10.0), Block.box((double)5.0, (double)6.0, (double)7.0, (double)11.0, (double)7.0, (double)9.0), Block.box((double)7.0, (double)6.0, (double)5.0, (double)9.0, (double)7.0, (double)11.0), Block.box((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), Block.box((double)4.0, (double)7.0, (double)7.0, (double)12.0, (double)10.0, (double)9.0), Block.box((double)7.0, (double)7.0, (double)4.0, (double)9.0, (double)10.0, (double)12.0), Block.box((double)5.0, (double)10.0, (double)4.0, (double)11.0, (double)15.0, (double)12.0), Block.box((double)4.0, (double)10.0, (double)5.0, (double)12.0, (double)15.0, (double)11.0), Block.box((double)3.0, (double)10.0, (double)6.0, (double)13.0, (double)15.0, (double)10.0), Block.box((double)6.0, (double)10.0, (double)3.0, (double)10.0, (double)15.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public GoldenSacrificialBowlBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
        level.scheduleTick(pos, (Block)this, 0);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = worldIn.getBlockEntity(pos);
            if (blockEntity != null) {
                GoldenSacrificialBowlBlockEntity bowl = (GoldenSacrificialBowlBlockEntity)blockEntity;
                bowl.stopRitual(false);
                StorageUtil.dropInventoryItems(bowl);
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof GoldenSacrificialBowlBlockEntity) {
            GoldenSacrificialBowlBlockEntity bowl = (GoldenSacrificialBowlBlockEntity)blockEntity;
            return bowl.activate(pLevel, pPos, pPlayer, pHand, pHitResult.getDirection()) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.getBlock().equals(OccultismBlocks.ELDRITCH_CHALICE.get())) {
            return SHAPE_TROPHY;
        }
        return SHAPE;
    }

    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        BlockEntity blockEntityAbove = pBlockAccess.getBlockEntity(pPos.above(3));
        if (blockEntityAbove instanceof GoldenSacrificialBowlBlockEntity) {
            GoldenSacrificialBowlBlockEntity bowl = (GoldenSacrificialBowlBlockEntity)blockEntityAbove;
            return bowl.getSignal();
        }
        BlockEntity blockEntity = pBlockAccess.getBlockEntity(pPos);
        if (blockEntity instanceof GoldenSacrificialBowlBlockEntity) {
            GoldenSacrificialBowlBlockEntity bowl = (GoldenSacrificialBowlBlockEntity)blockEntity;
            return bowl.getSignal();
        }
        return 0;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return OccultismBlockEntities.GOLDEN_SACRIFICIAL_BOWL.get().create(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return (l, p, s, be) -> {
            if (be instanceof GoldenSacrificialBowlBlockEntity) {
                GoldenSacrificialBowlBlockEntity bowl = (GoldenSacrificialBowlBlockEntity)be;
                bowl.tick();
            }
        };
    }
}

