/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.gui.spirit;

import com.klikli_dev.occultism.api.common.data.WorkAreaSize;
import com.klikli_dev.occultism.client.gui.controls.LabelWidget;
import com.klikli_dev.occultism.common.item.spirit.BookOfCallingItem;
import com.klikli_dev.occultism.common.item.spirit.calling.ItemMode;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageSetItemMode;
import com.klikli_dev.occultism.network.messages.MessageSetWorkAreaSize;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;

public class BookOfCallingGui
extends Screen {
    public ItemMode mode;
    public WorkAreaSize workAreaSize;

    public BookOfCallingGui(ItemMode mode, WorkAreaSize workAreaSize) {
        super((Component)Component.literal((String)""));
        this.mode = mode;
        this.workAreaSize = workAreaSize;
        this.init();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    protected void init() {
        super.init();
        this.clearWidgets();
        int guiLeft = this.width / 2;
        int guiTop = (this.height - 166) / 2;
        int buttonWidth = 150;
        LabelWidget modeLabel = new LabelWidget(guiLeft - 80, guiTop + 66, false, -1, 2, 0xFFFFFF).alignRight(true);
        modeLabel.addLine("gui.occultism.book_of_calling.mode", true);
        this.addRenderableWidget((GuiEventListener)modeLabel);
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(guiLeft - buttonWidth / 2, guiTop + 60, buttonWidth, 20, (Component)Component.translatable((String)this.mode.translationKey()), b -> {
            LocalPlayer player = Minecraft.getInstance().player;
            ItemStack stack = player.getMainHandItem();
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof BookOfCallingItem) {
                BookOfCallingItem bookOfCallingItem = (BookOfCallingItem)patt0$temp;
                this.mode = bookOfCallingItem.nextItemMode(stack);
                Networking.sendToServer(new MessageSetItemMode(((BookOfCallingItem)stack.getItem()).modeValue(this.mode)));
                this.init();
            }
        }));
        boolean showSize = this.mode.hasSize();
        if (showSize) {
            LabelWidget workAreaLabel = new LabelWidget(guiLeft - 80, guiTop + 91, true, -1, 2, 0xFFFFFF).alignRight(true);
            workAreaLabel.addLine("gui.occultism.book_of_calling.work_area", true);
            this.addRenderableWidget((GuiEventListener)workAreaLabel);
            this.addRenderableWidget((GuiEventListener)new ExtendedButton(guiLeft - buttonWidth / 2, guiTop + 85, buttonWidth, 20, (Component)Component.translatable((String)this.workAreaSize.getDescriptionId()), b -> {
                this.workAreaSize = this.workAreaSize.next();
                Networking.sendToServer(new MessageSetWorkAreaSize(this.workAreaSize));
                this.init();
            }));
        }
        int exitButtonWidth = 20;
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(guiLeft - exitButtonWidth / 2, guiTop + (showSize ? 110 : 85), exitButtonWidth, 20, (Component)Component.literal((String)"X"), b -> {
            this.minecraft.setScreen(null);
            this.init();
        }));
    }

    public boolean isPauseScreen() {
        return false;
    }
}

