/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.gui;

import com.klikli_dev.occultism.integration.apothicenchanting.ApothicEnchantingIntegration;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import org.jetbrains.annotations.NotNull;

public class IesniumAnvilMenu
extends AnvilMenu {
    public int repairItemCountCost;
    @Nullable
    private String itemName;
    private final DataSlot cost = DataSlot.standalone();

    public IesniumAnvilMenu(int containerId, Inventory playerInventory, ContainerLevelAccess access) {
        super(containerId, playerInventory, access);
    }

    protected boolean mayPickup(Player player, boolean hasStack) {
        return (player.hasInfiniteMaterials() || player.experienceLevel >= this.cost.get() / 2) && this.cost.get() > 0;
    }

    protected void onTake(Player player, @NotNull ItemStack stack) {
        if (!player.getAbilities().instabuild) {
            player.giveExperienceLevels(-this.cost.get() / 2);
        }
        this.inputSlots.setItem(0, ItemStack.EMPTY);
        if (this.repairItemCountCost > 0) {
            ItemStack itemstack = this.inputSlots.getItem(1);
            if (!itemstack.isEmpty() && itemstack.getCount() > this.repairItemCountCost) {
                itemstack.shrink(this.repairItemCountCost);
                this.inputSlots.setItem(1, itemstack);
            } else {
                this.inputSlots.setItem(1, ItemStack.EMPTY);
            }
        } else {
            this.inputSlots.setItem(1, ItemStack.EMPTY);
        }
        this.cost.set(0);
        this.access.execute((p_150479_, p_150480_) -> p_150479_.levelEvent(1030, p_150480_, 0));
    }

    public void createResult() {
        ItemStack itemstack = this.inputSlots.getItem(0);
        this.cost.set(1);
        int i = 0;
        long j = 0L;
        int k = 0;
        if (!itemstack.isEmpty() && EnchantmentHelper.canStoreEnchantments((ItemStack)itemstack)) {
            ItemStack itemstack1 = itemstack.copy();
            ItemStack itemstack2 = this.inputSlots.getItem(1);
            ItemEnchantments.Mutable itemenchantments$mutable = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemstack1));
            this.repairItemCountCost = 0;
            boolean flag = false;
            if (!IesniumAnvilMenu.onIesniumAnvilChange(this, itemstack, itemstack2, (Container)this.resultSlots, this.itemName, j += (long)((Integer)itemstack.getOrDefault(DataComponents.REPAIR_COST, (Object)0)).intValue() + (long)((Integer)itemstack2.getOrDefault(DataComponents.REPAIR_COST, (Object)0)).intValue(), this.player)) {
                return;
            }
            if (!itemstack2.isEmpty()) {
                flag = itemstack2.has(DataComponents.STORED_ENCHANTMENTS);
                if (itemstack1.isDamageableItem() && itemstack1.getItem().isValidRepairItem(itemstack, itemstack2)) {
                    int j3;
                    int l2 = Math.min(itemstack1.getDamageValue(), itemstack1.getMaxDamage() / 4);
                    if (l2 <= 0) {
                        this.resultSlots.setItem(0, ItemStack.EMPTY);
                        this.cost.set(0);
                        return;
                    }
                    for (j3 = 0; l2 > 0 && j3 < itemstack2.getCount(); ++j3) {
                        int k3 = itemstack1.getDamageValue() - l2;
                        itemstack1.setDamageValue(k3);
                        ++i;
                        l2 = Math.min(itemstack1.getDamageValue(), itemstack1.getMaxDamage() / 4);
                    }
                    this.repairItemCountCost = j3;
                } else {
                    if (!(flag || itemstack1.is(itemstack2.getItem()) && itemstack1.isDamageableItem())) {
                        this.resultSlots.setItem(0, ItemStack.EMPTY);
                        this.cost.set(0);
                        return;
                    }
                    if (itemstack1.isDamageableItem() && !flag) {
                        int l = itemstack.getMaxDamage() - itemstack.getDamageValue();
                        int i1 = itemstack2.getMaxDamage() - itemstack2.getDamageValue();
                        int j1 = i1 + itemstack1.getMaxDamage() * 12 / 100;
                        int k1 = l + j1;
                        int l1 = itemstack1.getMaxDamage() - k1;
                        if (l1 < 0) {
                            l1 = 0;
                        }
                        if (l1 < itemstack1.getDamageValue()) {
                            itemstack1.setDamageValue(l1);
                            i += 2;
                        }
                    }
                    ItemEnchantments itemenchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemstack2);
                    boolean flag2 = false;
                    boolean flag3 = false;
                    for (Object2IntMap.Entry entry : itemenchantments.entrySet()) {
                        int j2;
                        Holder holder = (Holder)entry.getKey();
                        int i2 = itemenchantments$mutable.getLevel(holder);
                        j2 = i2 == (j2 = entry.getIntValue()) ? j2 + 1 : Math.max(j2, i2);
                        Enchantment enchantment = (Enchantment)holder.value();
                        boolean flag1 = itemstack.supportsEnchantment(holder);
                        if (this.player.getAbilities().instabuild) {
                            flag1 = true;
                        }
                        for (Holder holder1 : itemenchantments$mutable.keySet()) {
                            if (holder1.equals((Object)holder) || Enchantment.areCompatible((Holder)holder, (Holder)holder1)) continue;
                            flag1 = false;
                            ++i;
                        }
                        if (!flag1) {
                            flag3 = true;
                            continue;
                        }
                        flag2 = true;
                        if (ApothicEnchantingIntegration.isLoaded()) {
                            if (j2 > ApothicEnchantingIntegration.getApothicMaxLevel(enchantment)) {
                                j2 = ApothicEnchantingIntegration.getApothicMaxLevel(enchantment) + 1;
                            }
                        } else if (j2 > enchantment.getMaxLevel()) {
                            j2 = enchantment.getMaxLevel() + 1;
                        }
                        itemenchantments$mutable.set(holder, j2);
                        int l3 = enchantment.getAnvilCost();
                        if (flag) {
                            l3 = Math.max(1, l3 / 2);
                        }
                        i += l3 * j2;
                        if (itemstack.getCount() <= 1) continue;
                        i = 40;
                    }
                    if (flag3 && !flag2) {
                        this.resultSlots.setItem(0, ItemStack.EMPTY);
                        this.cost.set(0);
                        return;
                    }
                }
            }
            if (this.itemName != null && !StringUtil.isBlank((String)this.itemName)) {
                if (!this.itemName.equals(itemstack.getHoverName().getString())) {
                    k = 1;
                    i += k;
                    itemstack1.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.itemName));
                }
            } else if (itemstack.has(DataComponents.CUSTOM_NAME)) {
                k = 1;
                i += k;
                itemstack1.remove(DataComponents.CUSTOM_NAME);
            }
            if (flag && !itemstack1.isBookEnchantable(itemstack2)) {
                itemstack1 = ItemStack.EMPTY;
            }
            int k2 = (int)Mth.clamp((long)(j + (long)i), (long)0L, (long)Integer.MAX_VALUE);
            this.cost.set(k2);
            if (i <= 0) {
                itemstack1 = ItemStack.EMPTY;
            }
            if (k == i && k > 0 && this.cost.get() >= 100) {
                this.cost.set(99);
            }
            if (this.cost.get() >= 100 && !this.player.getAbilities().instabuild) {
                itemstack1 = ItemStack.EMPTY;
            }
            if (!itemstack1.isEmpty()) {
                int i3 = (Integer)itemstack1.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
                if (i3 < (Integer)itemstack2.getOrDefault(DataComponents.REPAIR_COST, (Object)0)) {
                    i3 = (Integer)itemstack2.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
                }
                if (k != i || k == 0) {
                    i3 = IesniumAnvilMenu.calculateLowedIncreasedRepairCost(i3);
                }
                itemstack1.set(DataComponents.REPAIR_COST, (Object)i3);
                EnchantmentHelper.setEnchantments((ItemStack)itemstack1, (ItemEnchantments)itemenchantments$mutable.toImmutable());
            }
            this.resultSlots.setItem(0, itemstack1);
            this.broadcastChanges();
        } else {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
            this.cost.set(0);
        }
    }

    public static int calculateLowedIncreasedRepairCost(int oldRepairCost) {
        return (int)Math.min((long)oldRepairCost + 1L, Integer.MAX_VALUE);
    }

    public boolean setItemName(@NotNull String itemName) {
        String s = IesniumAnvilMenu.validateName(itemName);
        if (s != null && !s.equals(this.itemName)) {
            this.itemName = s;
            if (this.getSlot(2).hasItem()) {
                ItemStack itemstack = this.getSlot(2).getItem();
                if (StringUtil.isBlank((String)s)) {
                    itemstack.remove(DataComponents.CUSTOM_NAME);
                } else {
                    itemstack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)s));
                }
            }
            this.createResult();
            return true;
        }
        return false;
    }

    @Nullable
    private static String validateName(String itemName) {
        String s = StringUtil.filterText((String)itemName);
        return s.length() <= 50 ? s : null;
    }

    public void setMaximumCost(long value) {
        this.cost.set((int)Mth.clamp((long)(value / 2L), (long)0L, (long)Integer.MAX_VALUE));
    }

    public static boolean onIesniumAnvilChange(IesniumAnvilMenu container, ItemStack left, ItemStack right, Container outputSlot, String name, long baseCost, Player player) {
        AnvilUpdateEvent e = new AnvilUpdateEvent(left, right, name, baseCost, player);
        if (((AnvilUpdateEvent)NeoForge.EVENT_BUS.post((Event)e)).isCanceled()) {
            return false;
        }
        if (e.getOutput().isEmpty()) {
            return true;
        }
        outputSlot.setItem(0, e.getOutput());
        container.setMaximumCost(e.getCost());
        container.repairItemCountCost = e.getMaterialCost();
        return false;
    }
}

