/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.part;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientInstanceWrapper;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integratedcrafting.Capabilities;
import org.cyclops.integratedcrafting.GeneralConfig;
import org.cyclops.integratedcrafting.IntegratedCrafting;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.api.crafting.CraftingJobStatus;
import org.cyclops.integratedcrafting.api.crafting.ICraftingInterface;
import org.cyclops.integratedcrafting.api.crafting.ICraftingResultsSink;
import org.cyclops.integratedcrafting.api.network.ICraftingNetwork;
import org.cyclops.integratedcrafting.core.CraftingHelpers;
import org.cyclops.integratedcrafting.core.CraftingJobHandler;
import org.cyclops.integratedcrafting.core.CraftingProcessOverrides;
import org.cyclops.integratedcrafting.core.part.PartTypeCraftingBase;
import org.cyclops.integratedcrafting.ingredient.storage.IngredientComponentStorageSlottedInsertProxy;
import org.cyclops.integratedcrafting.inventory.container.ContainerPartInterfaceCrafting;
import org.cyclops.integratedcrafting.inventory.container.ContainerPartInterfaceCraftingSettings;
import org.cyclops.integratedcrafting.part.PartTypes;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkIngredientsChannel;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.network.NetworkCapability;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartCapability;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.PrioritizedPartPos;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartStateBase;
import org.cyclops.integrateddynamics.core.part.event.PartVariableDrivenVariableContentsUpdatedEvent;

public class PartTypeInterfaceCrafting
extends PartTypeCraftingBase<PartTypeInterfaceCrafting, State> {
    public PartTypeInterfaceCrafting(String name) {
        super(name);
    }

    public int getConsumptionRate(State state) {
        return state.getCraftingJobHandler().getProcessingCraftingJobs().size() * GeneralConfig.interfaceCraftingBaseConsumption;
    }

    @Override
    public Optional<MenuProvider> getContainerProvider(final PartPos pos) {
        return Optional.of(new MenuProvider(){

            public MutableComponent getDisplayName() {
                return Component.translatable((String)PartTypeInterfaceCrafting.this.getTranslationKey());
            }

            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)pos);
                State partState = (State)((IPartContainer)data.getLeft()).getPartState(((PartTarget)data.getRight()).getCenter().getSide());
                return new ContainerPartInterfaceCrafting(id, playerInventory, (Container)partState.getInventoryVariables(), Optional.of((PartTarget)data.getRight()), Optional.of((IPartContainer)data.getLeft()), (PartTypeInterfaceCrafting)((Object)data.getMiddle()));
            }
        });
    }

    public void writeExtraGuiData(RegistryFriendlyByteBuf packetBuffer, PartPos pos, ServerPlayer player) {
        IPartContainer partContainer = PartHelpers.getPartContainerChecked((PartPos)pos);
        State partState = (State)partContainer.getPartState(pos.getSide());
        packetBuffer.writeInt(partState.getInventoryVariables().getContainerSize());
        super.writeExtraGuiData(packetBuffer, pos, player);
    }

    public Optional<MenuProvider> getContainerProviderSettings(final PartPos pos) {
        return Optional.of(new MenuProvider(){

            public MutableComponent getDisplayName() {
                return Component.translatable((String)PartTypeInterfaceCrafting.this.getTranslationKey());
            }

            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)pos);
                return new ContainerPartInterfaceCraftingSettings(id, playerInventory, (Container)new SimpleContainer(0), (PartTarget)data.getRight(), Optional.of((IPartContainer)data.getLeft()), (IPartType)data.getMiddle());
            }
        });
    }

    protected State constructDefaultState() {
        return new State();
    }

    public void afterNetworkReAlive(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        super.afterNetworkReAlive(network, partNetwork, target, (IPartState)state);
        this.addTargetToNetwork(network, target, state, true);
    }

    public void onNetworkRemoval(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        super.onNetworkRemoval(network, partNetwork, target, (IPartState)state);
        this.removeTargetFromNetwork(network, target.getTarget(), state);
    }

    public void onNetworkAddition(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        super.onNetworkAddition(network, partNetwork, target, (IPartState)state);
        this.addTargetToNetwork(network, target, state, true);
    }

    public void setPriorityAndChannel(INetwork network, IPartNetwork partNetwork, PartTarget target, State state, int priority, int channel) {
        this.removeTargetFromNetwork(network, target.getTarget(), state);
        super.setPriorityAndChannel(network, partNetwork, target, (IPartState)state, priority, channel);
        this.addTargetToNetwork(network, target, state, false);
    }

    protected NetworkCapability<ICraftingNetwork> getNetworkCapability() {
        return Capabilities.CraftingNetwork.NETWORK;
    }

    protected void addTargetToNetwork(INetwork network, PartTarget pos, State state, boolean initialize) {
        network.getCapability(this.getNetworkCapability()).ifPresent(craftingNetwork -> {
            int channelCrafting = state.getChannelCrafting();
            state.setTarget(pos);
            state.setNetworks(network, (ICraftingNetwork)craftingNetwork, NetworkHelpers.getPartNetworkChecked((INetwork)network), channelCrafting, ValueDeseralizationContext.of((net.minecraft.world.level.Level)pos.getCenter().getPos().getLevel(true)), initialize);
            state.setShouldAddToCraftingNetwork(true);
        });
    }

    protected void removeTargetFromNetwork(INetwork network, PartPos pos, State state) {
        ICraftingNetwork craftingNetwork = state.getCraftingNetwork();
        if (craftingNetwork != null) {
            network.getCapability(this.getNetworkCapability()).ifPresent(n -> n.removeCraftingInterface(state.getChannelCrafting(), state));
        }
        state.setNetworks(null, null, null, -1, null, false);
        state.setTarget(null);
    }

    public boolean isUpdate(State state) {
        return true;
    }

    public int getMinimumUpdateInterval(State state) {
        return state.getDefaultUpdateInterval();
    }

    public void update(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        ICraftingNetwork craftingNetwork;
        IntSet slots;
        super.update(network, partNetwork, target, (IPartState)state);
        if (state.getCraftingNetwork() == null) {
            this.addTargetToNetwork(network, target, state, false);
        }
        int channel = state.getChannelCrafting();
        if (state.shouldAddToCraftingNetwork()) {
            ICraftingNetwork craftingNetwork2 = network.getCapability(this.getNetworkCapability()).orElse(null);
            craftingNetwork2.addCraftingInterface(channel, state);
            state.setShouldAddToCraftingNetwork(false);
        }
        state.flushInventoryOutputBuffer(network);
        if (state.getInventoryOutputBuffer().isEmpty()) {
            PartPos targetPos = state.getTarget().getTarget();
            state.getCraftingJobHandler().update(network, channel, targetPos);
        }
        if (!(slots = state.getDelayedRecipeReloads()).isEmpty() && (craftingNetwork = (ICraftingNetwork)network.getCapability(this.getNetworkCapability()).orElse(null)) != null) {
            IntOpenHashSet slotsCopy = new IntOpenHashSet((IntCollection)slots);
            slots.clear();
            for (Integer slot : slotsCopy) {
                Int2ObjectMap<IRecipeDefinition> recipes = state.getRecipesIndexed();
                IRecipeDefinition oldRecipe = (IRecipeDefinition)recipes.get((Object)slot);
                if (oldRecipe != null) {
                    craftingNetwork.removeCraftingInterfaceRecipe(channel, state, oldRecipe);
                }
                state.reloadRecipe(slot, state.ticksAfterReload <= 1);
                IRecipeDefinition newRecipe = (IRecipeDefinition)recipes.get((Object)slot);
                if (newRecipe == null) continue;
                craftingNetwork.addCraftingInterfaceRecipe(channel, state, newRecipe);
            }
        }
        ++state.ticksAfterReload;
    }

    @Nullable
    protected static <T, M> IngredientInstanceWrapper<T, M> insertIntoNetwork(IngredientInstanceWrapper<T, M> wrapper, INetwork network, int channel) {
        IPositionedAddonsNetworkIngredients storageNetwork = wrapper.getComponent().getCapability(Capabilities.PositionedAddonsNetworkIngredientsHandler.INGREDIENT).map(n -> n.getStorage(network).orElse(null)).orElse(null);
        if (storageNetwork != null) {
            INetworkIngredientsChannel storage = storageNetwork.getChannel(channel);
            Object remaining = storage.insert(wrapper.getInstance(), false);
            if (wrapper.getComponent().getMatcher().isEmpty(remaining)) {
                return null;
            }
            return new IngredientInstanceWrapper(wrapper.getComponent(), remaining);
        }
        return wrapper;
    }

    public void addDrops(PartTarget target, State state, List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
        for (IngredientInstanceWrapper<?, ?> ingredientInstanceWrapper : state.getInventoryOutputBuffer()) {
            if (ingredientInstanceWrapper.getComponent() != IngredientComponent.ITEMSTACK) continue;
            itemStacks.add((ItemStack)ingredientInstanceWrapper.getInstance());
        }
        state.getInventoryOutputBuffer().clear();
        for (int i = 0; i < state.getInventoryVariables().getContainerSize(); ++i) {
            ItemStack itemStack = state.getInventoryVariables().getItem(i);
            if (itemStack.isEmpty()) continue;
            itemStacks.add(itemStack);
        }
        state.getInventoryVariables().clearContent();
        super.addDrops(target, (IPartState)state, itemStacks, dropMainElement, saveState);
    }

    public static class State
    extends PartStateBase<PartTypeInterfaceCrafting>
    implements ICraftingInterface,
    ICraftingResultsSink {
        protected int ticksAfterReload = 0;
        private final CraftingJobHandler craftingJobHandler = new CraftingJobHandler(1, true, CraftingProcessOverrides.REGISTRY.getCraftingProcessOverrides(), this);
        private final SimpleInventory inventoryVariables = new SimpleInventory(9, 1);
        private final List<InventoryVariableEvaluator<ValueObjectTypeRecipe.ValueRecipe>> variableEvaluators;
        private final List<IngredientInstanceWrapper<?, ?>> inventoryOutputBuffer;
        private final Int2ObjectMap<MutableComponent> recipeSlotMessages;
        private final Int2BooleanMap recipeSlotValidated;
        private final IntSet delayedRecipeReloads;
        private final Map<IVariable, Boolean> variableListeners;
        private int channelCrafting = 0;
        private boolean disableCraftingCheck = false;
        private final Int2ObjectMap<IRecipeDefinition> currentRecipes;
        private PartTarget target = null;
        private INetwork network = null;
        private ICraftingNetwork craftingNetwork = null;
        private IPartNetwork partNetwork = null;
        private int channel = -1;
        private ValueDeseralizationContext valueDeseralizationContext;
        private boolean shouldAddToCraftingNetwork = false;
        private Player lastPlayer;

        public State() {
            this.inventoryVariables.addDirtyMarkListener((IDirtyMarkListener)this);
            this.variableEvaluators = Lists.newArrayList();
            this.inventoryOutputBuffer = Lists.newArrayList();
            this.recipeSlotMessages = new Int2ObjectArrayMap();
            this.recipeSlotValidated = new Int2BooleanArrayMap();
            this.delayedRecipeReloads = new IntArraySet();
            this.variableListeners = new MapMaker().weakKeys().makeMap();
            this.currentRecipes = new Int2ObjectArrayMap();
        }

        protected int getDefaultUpdateInterval() {
            return GeneralConfig.minCraftingInterfaceUpdateFreq;
        }

        public SimpleInventory getInventoryVariables() {
            return this.inventoryVariables;
        }

        public void writeToNBT(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag) {
            super.writeToNBT(valueDeseralizationContext, tag);
            this.inventoryVariables.writeToNBT(valueDeseralizationContext.holderLookupProvider(), tag, "variables");
            ListTag instanceTags = new ListTag();
            for (IngredientInstanceWrapper<?, ?> ingredientInstanceWrapper : this.inventoryOutputBuffer) {
                CompoundTag instanceTag = new CompoundTag();
                instanceTag.putString("component", IngredientComponent.REGISTRY.getKey((Object)ingredientInstanceWrapper.getComponent()).toString());
                instanceTag.put("instance", ingredientInstanceWrapper.getComponent().getSerializer().serializeInstance(valueDeseralizationContext.holderLookupProvider(), ingredientInstanceWrapper.getInstance()));
                instanceTags.add((Object)instanceTag);
            }
            tag.put("inventoryOutputBuffer", (Tag)instanceTags);
            this.craftingJobHandler.writeToNBT(valueDeseralizationContext.holderLookupProvider(), tag);
            tag.putInt("channelCrafting", this.channelCrafting);
            CompoundTag recipeSlotErrorsTag = new CompoundTag();
            for (Int2ObjectMap.Entry entry : this.recipeSlotMessages.int2ObjectEntrySet()) {
                NBTClassType.writeNbt(MutableComponent.class, (String)String.valueOf(entry.getIntKey()), (Object)((MutableComponent)entry.getValue()), (CompoundTag)recipeSlotErrorsTag, (HolderLookup.Provider)valueDeseralizationContext.holderLookupProvider());
            }
            tag.put("recipeSlotMessages", (Tag)recipeSlotErrorsTag);
            CompoundTag compoundTag = new CompoundTag();
            for (Int2BooleanMap.Entry entry : this.recipeSlotValidated.int2BooleanEntrySet()) {
                compoundTag.putBoolean(String.valueOf(entry.getIntKey()), entry.getBooleanValue());
            }
            tag.put("recipeSlotValidated", (Tag)compoundTag);
            tag.putBoolean("disableCraftingCheck", this.disableCraftingCheck);
        }

        public void readFromNBT(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag) {
            super.readFromNBT(valueDeseralizationContext, tag);
            this.inventoryVariables.readFromNBT(valueDeseralizationContext.holderLookupProvider(), tag, "variables");
            this.inventoryOutputBuffer.clear();
            for (Object instanceTagRaw : tag.getList("inventoryOutputBuffer", 10)) {
                CompoundTag instanceTag = (CompoundTag)instanceTagRaw;
                String componentName = instanceTag.getString("component");
                IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.get(ResourceLocation.parse((String)componentName));
                this.inventoryOutputBuffer.add(new IngredientInstanceWrapper(component, component.getSerializer().deserializeInstance(valueDeseralizationContext.holderLookupProvider(), instanceTag.get("instance"))));
            }
            this.craftingJobHandler.readFromNBT(valueDeseralizationContext.holderLookupProvider(), tag);
            this.channelCrafting = tag.getInt("channelCrafting");
            this.recipeSlotMessages.clear();
            CompoundTag recipeSlotErrorsTag = tag.getCompound("recipeSlotMessages");
            for (String slot : recipeSlotErrorsTag.getAllKeys()) {
                MutableComponent unlocalizedString = (MutableComponent)NBTClassType.readNbt(MutableComponent.class, (String)slot, (CompoundTag)recipeSlotErrorsTag, (HolderLookup.Provider)valueDeseralizationContext.holderLookupProvider());
                this.recipeSlotMessages.put(Integer.parseInt(slot), (Object)unlocalizedString);
            }
            this.recipeSlotValidated.clear();
            CompoundTag recipeSlotValidatedTag = tag.getCompound("recipeSlotValidated");
            for (String slot : recipeSlotValidatedTag.getAllKeys()) {
                this.recipeSlotValidated.put(Integer.parseInt(slot), recipeSlotValidatedTag.getBoolean(slot));
            }
            this.disableCraftingCheck = tag.getBoolean("disableCraftingCheck");
        }

        public void setChannelCrafting(int channelCrafting) {
            if (this.channelCrafting != channelCrafting) {
                if (this.craftingNetwork != null) {
                    this.craftingNetwork.removeCraftingInterface(this.channelCrafting, this);
                }
                this.channelCrafting = channelCrafting;
                if (this.craftingNetwork != null) {
                    this.craftingNetwork.addCraftingInterface(this.channelCrafting, this);
                }
                this.sendUpdate();
            }
        }

        public int getChannelCrafting() {
            return this.channelCrafting;
        }

        public void reloadRecipes(boolean initialize) {
            this.currentRecipes.clear();
            this.recipeSlotMessages.clear();
            this.recipeSlotValidated.clear();
            this.variableEvaluators.clear();
            int i = 0;
            while (i < this.getInventoryVariables().getContainerSize()) {
                final int slot = i++;
                this.variableEvaluators.add(new InventoryVariableEvaluator<ValueObjectTypeRecipe.ValueRecipe>((Container)this.getInventoryVariables(), slot, this.valueDeseralizationContext, (IValueType)ValueTypes.OBJECT_RECIPE){

                    public void onErrorsChanged() {
                        super.onErrorsChanged();
                        this.setLocalErrors(slot, this.getErrors());
                    }
                });
            }
            if (this.partNetwork != null) {
                for (i = 0; i < this.getInventoryVariables().getContainerSize(); ++i) {
                    this.reloadRecipe(i, initialize);
                }
            }
        }

        private void setLocalErrors(int slot, List<MutableComponent> errors) {
            if (errors.isEmpty()) {
                if (this.recipeSlotMessages.size() > slot) {
                    this.recipeSlotMessages.remove(slot);
                }
            } else {
                this.recipeSlotMessages.put(slot, (Object)errors.get(0));
            }
        }

        protected void reloadRecipe(int slot, boolean initialize) {
            this.currentRecipes.remove(slot);
            if (this.recipeSlotMessages.size() > slot) {
                this.recipeSlotMessages.remove(slot);
            }
            if (this.recipeSlotValidated.size() > slot) {
                this.recipeSlotValidated.remove(slot);
            }
            if (this.partNetwork != null) {
                IVariable variable;
                block16: {
                    InventoryVariableEvaluator<ValueObjectTypeRecipe.ValueRecipe> evaluator = this.variableEvaluators.get(slot);
                    evaluator.refreshVariable(this.network, false);
                    variable = evaluator.getVariable(this.network);
                    if (variable != null) {
                        try {
                            IValue value;
                            if (!this.variableListeners.containsKey(variable)) {
                                variable.addInvalidationListener(() -> {
                                    this.variableListeners.remove(variable);
                                    this.delayedReloadRecipe(slot);
                                });
                                this.variableListeners.put(variable, true);
                            }
                            if ((value = variable.getValue()).getType() == ValueTypes.OBJECT_RECIPE) {
                                Optional recipeWrapper = ((ValueObjectTypeRecipe.ValueRecipe)value).getRawValue();
                                if (recipeWrapper.isPresent()) {
                                    IRecipeDefinition recipe = (IRecipeDefinition)recipeWrapper.get();
                                    if (!GeneralConfig.validateRecipesCraftingInterface || this.disableCraftingCheck || this.isValid(recipe)) {
                                        this.currentRecipes.put(slot, (Object)recipe);
                                        this.recipeSlotValidated.put(slot, true);
                                        this.recipeSlotMessages.put(slot, (Object)Component.translatable((String)"gui.integratedcrafting.partinterface.slot.message.valid"));
                                    } else {
                                        this.recipeSlotMessages.put(slot, (Object)Component.translatable((String)"gui.integratedcrafting.partinterface.slot.message.invalid"));
                                    }
                                }
                                break block16;
                            }
                            this.recipeSlotMessages.put(slot, (Object)Component.translatable((String)"gui.integratedcrafting.partinterface.slot.message.norecipe"));
                        }
                        catch (EvaluationException e) {
                            this.recipeSlotMessages.put(slot, (Object)e.getErrorMessage());
                        }
                    } else if (initialize && evaluator.hasVariable()) {
                        this.delayedReloadRecipe(slot);
                    } else {
                        this.recipeSlotMessages.put(slot, (Object)Component.translatable((String)"gui.integratedcrafting.partinterface.slot.message.norecipe"));
                    }
                }
                try {
                    IPartNetwork partNetwork = NetworkHelpers.getPartNetworkChecked((INetwork)this.network);
                    NeoForge.EVENT_BUS.post((Event)new PartVariableDrivenVariableContentsUpdatedEvent(this.network, partNetwork, this.getTarget(), (IPartType)PartTypes.INTERFACE_CRAFTING, (IPartState)this, this.lastPlayer, variable, variable != null ? variable.getValue() : null));
                }
                catch (EvaluationException evaluationException) {
                    // empty catch block
                }
            }
            this.sendUpdate();
        }

        public void setLastPlayer(Player lastPlayer) {
            this.lastPlayer = lastPlayer;
        }

        private void delayedReloadRecipe(int slot) {
            this.delayedRecipeReloads.add(slot);
        }

        private boolean isValid(IRecipeDefinition recipe) {
            DimPos dimPos = this.getTarget().getTarget().getPos();
            Direction side = this.getTarget().getTarget().getSide();
            IRecipeHandler recipeHandler = BlockEntityHelpers.getCapability((ILevelExtension)dimPos.getLevel(true), (BlockPos)dimPos.getBlockPos(), (Object)side, (BlockCapability)Capabilities.RecipeHandler.BLOCK).orElse(null);
            if (recipeHandler != null) {
                IMixedIngredients simulatedOutput = recipeHandler.simulate((IMixedIngredients)MixedIngredients.fromRecipeInput((IRecipeDefinition)recipe));
                if (simulatedOutput != null && !simulatedOutput.isEmpty()) {
                    if (recipe.getOutput().containsAll(simulatedOutput)) {
                        return true;
                    }
                    if (GeneralConfig.logRecipeValidationFailures) {
                        IntegratedCrafting.clog(Level.INFO, "Recipe validation failure: incompatible recipe output and simulated output:\nRecipe output: " + String.valueOf(recipe.getOutput()) + "\nSimulated output: " + String.valueOf(simulatedOutput));
                    }
                    return false;
                }
                if (GeneralConfig.logRecipeValidationFailures) {
                    IntegratedCrafting.clog(Level.INFO, "Recipe validation failure: No output was obtained when simulating a recipe\n" + String.valueOf(recipe));
                }
                return false;
            }
            return true;
        }

        public void onDirty() {
            super.onDirty();
            if (this.craftingNetwork != null) {
                this.craftingNetwork.removeCraftingInterface(this.channelCrafting, this);
            }
            if (this.getTarget() != null && !this.getTarget().getCenter().getPos().getLevel((boolean)true).isClientSide) {
                this.reloadRecipes(false);
            }
            if (this.craftingNetwork != null) {
                this.craftingNetwork.addCraftingInterface(this.channelCrafting, this);
            }
        }

        public void setTarget(PartTarget target) {
            this.target = target;
        }

        public PartTarget getTarget() {
            return this.target;
        }

        public void setNetworks(@Nullable INetwork network, @Nullable ICraftingNetwork craftingNetwork, @Nullable IPartNetwork partNetwork, int channel, @Nullable ValueDeseralizationContext valueDeseralizationContext, boolean initialize) {
            this.network = network;
            this.craftingNetwork = craftingNetwork;
            this.partNetwork = partNetwork;
            this.channel = channel;
            this.valueDeseralizationContext = valueDeseralizationContext;
            this.reloadRecipes(initialize);
            if (network != null) {
                this.getCraftingJobHandler().reRegisterObservers(network);
            }
        }

        public ICraftingNetwork getCraftingNetwork() {
            return this.craftingNetwork;
        }

        public int getChannel() {
            return this.channel;
        }

        @Override
        public Collection<IRecipeDefinition> getRecipes() {
            return this.currentRecipes.values();
        }

        public Int2ObjectMap<IRecipeDefinition> getRecipesIndexed() {
            return this.currentRecipes;
        }

        @Override
        public boolean canScheduleCraftingJobs() {
            return this.getCraftingJobHandler().canScheduleCraftingJobs();
        }

        @Override
        public void scheduleCraftingJob(CraftingJob craftingJob) {
            this.getCraftingJobHandler().scheduleCraftingJob(craftingJob);
        }

        @Override
        public int getCraftingJobsCount() {
            return this.craftingJobHandler.getAllCraftingJobs().size();
        }

        @Override
        public Iterator<CraftingJob> getCraftingJobs() {
            return this.craftingJobHandler.getAllCraftingJobs().values().iterator();
        }

        @Override
        public List<Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>>> getPendingCraftingJobOutputs(int craftingJobId) {
            List pending = (List)this.craftingJobHandler.getProcessingCraftingJobsPendingIngredients().get(craftingJobId);
            if (pending == null) {
                pending = Lists.newArrayList();
            }
            return pending;
        }

        @Override
        public CraftingJobStatus getCraftingJobStatus(ICraftingNetwork network, int channel, int craftingJobId) {
            return this.craftingJobHandler.getCraftingJobStatus(network, channel, craftingJobId);
        }

        @Override
        public void cancelCraftingJob(int channel, int craftingJobId) {
            this.craftingJobHandler.markCraftingJobFinished(craftingJobId);
        }

        @Override
        public PrioritizedPartPos getPosition() {
            return PrioritizedPartPos.of((PartPos)this.getTarget().getCenter(), (int)this.getPriority());
        }

        public CraftingJobHandler getCraftingJobHandler() {
            return this.craftingJobHandler;
        }

        public boolean shouldAddToCraftingNetwork() {
            return this.shouldAddToCraftingNetwork;
        }

        public void setShouldAddToCraftingNetwork(boolean shouldAddToCraftingNetwork) {
            this.shouldAddToCraftingNetwork = shouldAddToCraftingNetwork;
        }

        public List<IngredientInstanceWrapper<?, ?>> getInventoryOutputBuffer() {
            return this.inventoryOutputBuffer;
        }

        public <T> Optional<T> getCapability(PartTypeInterfaceCrafting partType, PartCapability<T> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
            T cap;
            IngredientComponent ingredientComponent;
            if (capability == Capabilities.CraftingInterface.PART) {
                return Optional.of(this);
            }
            if (this.network != null && (ingredientComponent = IngredientComponent.getIngredientComponentForStorageCapability(capability)) != null && (cap = this.wrapStorageCapability(capability, ingredientComponent)) != null) {
                return Optional.of(cap);
            }
            return super.getCapability((IPartType)partType, capability, network, partNetwork, target);
        }

        protected <C, T, M> C wrapStorageCapability(PartCapability<C> capability, IngredientComponent<T, M> ingredientComponent) {
            Object storage = CraftingHelpers.getNetworkStorage(this.network, this.channelCrafting, ingredientComponent, false);
            storage = new IngredientComponentStorageSlottedInsertProxy<T, M>(storage);
            return (C)ingredientComponent.getStorageWrapperHandler(capability).wrapStorage(storage);
        }

        @Override
        public <T, M> void addResult(IngredientComponent<T, M> ingredientComponent, T instance) {
            this.getInventoryOutputBuffer().add(new IngredientInstanceWrapper(ingredientComponent, instance));
            if (this.network != null) {
                this.flushInventoryOutputBuffer(this.network);
            }
        }

        public void setIngredientComponentTargetSideOverride(IngredientComponent<?, ?> ingredientComponent, Direction side) {
            if (this.getTarget().getTarget().getSide() == side) {
                this.craftingJobHandler.setIngredientComponentTarget(ingredientComponent, null);
            } else {
                this.craftingJobHandler.setIngredientComponentTarget(ingredientComponent, side);
            }
            this.sendUpdate();
        }

        public Direction getIngredientComponentTargetSideOverride(IngredientComponent<?, ?> ingredientComponent) {
            Direction side = this.craftingJobHandler.getIngredientComponentTarget(ingredientComponent);
            if (side == null) {
                side = this.getTarget().getTarget().getSide();
            }
            return side;
        }

        public boolean isRecipeSlotValid(int slot) {
            return this.recipeSlotValidated.containsKey(slot);
        }

        @Nullable
        public MutableComponent getRecipeSlotUnlocalizedMessage(int slot) {
            return (MutableComponent)this.recipeSlotMessages.get(slot);
        }

        public IntSet getDelayedRecipeReloads() {
            return this.delayedRecipeReloads;
        }

        public void setDisableCraftingCheck(boolean disableCraftingCheck) {
            if (disableCraftingCheck != this.disableCraftingCheck) {
                this.disableCraftingCheck = disableCraftingCheck;
                this.sendUpdate();
            }
        }

        public boolean isDisableCraftingCheck() {
            return this.disableCraftingCheck;
        }

        public void flushInventoryOutputBuffer(INetwork network) {
            boolean changed = false;
            ListIterator<IngredientInstanceWrapper<?, ?>> outputBufferIt = this.getInventoryOutputBuffer().listIterator();
            while (outputBufferIt.hasNext()) {
                IngredientInstanceWrapper<?, ?> oldWrapper = outputBufferIt.next();
                this.forceObservationOnInsertable(oldWrapper);
                IngredientInstanceWrapper<?, ?> newWrapper = PartTypeInterfaceCrafting.insertIntoNetwork(oldWrapper, network, this.getChannelCrafting());
                if (newWrapper != oldWrapper) {
                    changed = true;
                }
                if (newWrapper == null) {
                    outputBufferIt.remove();
                    continue;
                }
                outputBufferIt.set(newWrapper);
            }
            if (changed) {
                CraftingHelpers.beforeCalculateCraftingJobs(network, this.getChannelCrafting());
            }
        }

        protected <T, M> void forceObservationOnInsertable(IngredientInstanceWrapper<T, M> oldWrapper) {
            IIngredientMatcher matcher = oldWrapper.getComponent().getMatcher();
            IPositionedAddonsNetworkIngredients ingredientsNetwork = CraftingHelpers.getIngredientsNetwork(this.network, oldWrapper.getComponent()).orElse(null);
            if (ingredientsNetwork != null) {
                boolean marked = false;
                INetworkIngredientsChannel ingredientsNetworkChannel = ingredientsNetwork.getChannel(this.getChannelCrafting());
                Object instance = oldWrapper.getInstance();
                for (PartPos position : ingredientsNetworkChannel.findNonFullPositions()) {
                    Object instanceOut = ingredientsNetwork.getPositionedStorage(position).insert(instance, true);
                    if (matcher.matchesExactly(instanceOut, instance)) continue;
                    marked = true;
                    instance = instanceOut;
                    ingredientsNetwork.scheduleObservationForced(this.getChannelCrafting(), position);
                    if (!matcher.isEmpty(instance)) continue;
                    break;
                }
                if (marked || ingredientsNetwork.isObservationForcedPending(this.channel)) {
                    ingredientsNetwork.runObserverSync();
                }
            }
        }
    }
}

