/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc.common.impl;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.darkhax.bookshelf.common.api.PhysicalSide;
import net.darkhax.bookshelf.common.api.annotation.OnlyFor;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.enchdesc.common.impl.Config;
import net.darkhax.pricklemc.common.api.config.ConfigManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;

public class EnchdescMod {
    private static final String[] KEY_TYPES = new String[]{"desc", "description", "info"};
    private static EnchdescMod instance;
    private boolean hasInitialized = false;
    private Config config;

    public void init() {
        if (this.hasInitialized) {
            throw new IllegalStateException("The EnchantmentDescriptions has already been initialized.");
        }
        if (Services.PLATFORM.isPhysicalClient()) {
            this.config = (Config)ConfigManager.load((String)"enchdesc", (Object)new Config());
        }
        this.hasInitialized = true;
    }

    @OnlyFor(value=PhysicalSide.CLIENT)
    public void insertDescriptions(ItemStack stack, List<Component> lines) {
        if (this.hasInitialized && this.config.enabled && this.hasEnchantments(stack)) {
            if (this.config.only_on_books && !(stack.getItem() instanceof EnchantedBookItem)) {
                return;
            }
            if (this.config.only_in_enchanting_table && !(Minecraft.getInstance().screen instanceof EnchantmentScreen)) {
                return;
            }
            if (this.config.require_keybind && !Screen.hasShiftDown()) {
                if (this.config.activate_text.getContents() != PlainTextContents.EMPTY) {
                    lines.add(this.config.activate_text);
                }
                return;
            }
            this.insertDescriptions(stack.getEnchantments(), lines);
            this.insertDescriptions((ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY), lines);
        }
    }

    private boolean hasEnchantments(ItemStack stack) {
        return !((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).isEmpty() || !((ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).isEmpty();
    }

    @OnlyFor(value=PhysicalSide.CLIENT)
    private void insertDescriptions(ItemEnchantments enchantments, List<Component> lines) {
        if (!enchantments.isEmpty()) {
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                ((Holder)entry.getKey()).unwrapKey().ifPresent(key -> {
                    Component fullName = Enchantment.getFullname((Holder)((Holder)entry.getKey()), (int)entry.getIntValue());
                    for (Component line : lines) {
                        MutableComponent description;
                        int index;
                        if (!fullName.equals((Object)line) || (index = lines.indexOf(line)) == -1 || (description = this.getDescription((Holder<Enchantment>)((Holder)entry.getKey()), key.location(), entry.getIntValue())) == null) continue;
                        ComponentUtils.mergeStyles((MutableComponent)description, (Style)this.config.style);
                        lines.add(index + 1, (Component)this.config.prefix.copy().append((Component)description).append(this.config.suffix));
                        break;
                    }
                });
            }
        }
    }

    @Nullable
    @OnlyFor(value=PhysicalSide.CLIENT)
    private MutableComponent getDescription(Holder<Enchantment> enchantment, ResourceLocation id, int level) {
        ComponentContents componentContents;
        MutableComponent description = this.getDescription("enchantment." + id.getNamespace() + "." + id.getPath() + ".", level);
        if (description == null && (componentContents = ((Enchantment)enchantment.value()).description().getContents()) instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            description = this.getDescription(translatable.getKey() + ".", level);
        }
        return description;
    }

    @Nullable
    @OnlyFor(value=PhysicalSide.CLIENT)
    private MutableComponent getDescription(String baseKey, int level) {
        for (String keyType : KEY_TYPES) {
            String key = baseKey + keyType;
            if (I18n.exists((String)key)) {
                return Component.translatable((String)key);
            }
            if (!I18n.exists((String)(key = key + "." + level))) continue;
            return Component.translatable((String)key);
        }
        return null;
    }

    public boolean hasInitialized() {
        return this.hasInitialized;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static EnchdescMod getInstance() {
        if (instance == null) {
            instance = new EnchdescMod();
        }
        return instance;
    }
}

