/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.util;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeUtils {
    public static VoxelShape rotateY(VoxelShape shape, int rotation) {
        ArrayList rotatedShapes = new ArrayList();
        shape.forAllBoxes((x1, y1, z1, x2, y2, z2) -> {
            x1 = x1 * 16.0 - 8.0;
            x2 = x2 * 16.0 - 8.0;
            z1 = z1 * 16.0 - 8.0;
            z2 = z2 * 16.0 - 8.0;
            switch (rotation) {
                case 90: {
                    rotatedShapes.add(VoxelShapeUtils.boxSafe(8.0 - z1, y1 * 16.0, 8.0 + x1, 8.0 - z2, y2 * 16.0, 8.0 + x2));
                    break;
                }
                case 180: {
                    rotatedShapes.add(VoxelShapeUtils.boxSafe(8.0 - x1, y1 * 16.0, 8.0 - z1, 8.0 - x2, y2 * 16.0, 8.0 - z2));
                    break;
                }
                case 270: {
                    rotatedShapes.add(VoxelShapeUtils.boxSafe(8.0 + z1, y1 * 16.0, 8.0 - x1, 8.0 + z2, y2 * 16.0, 8.0 - x2));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid rotation " + rotation + " (must be 90,180 or 270)");
                }
            }
        });
        return rotatedShapes.stream().reduce((v1, v2) -> Shapes.joinUnoptimized((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).orElse(shape).optimize();
    }

    public static VoxelShape rotateX(VoxelShape shape, int rotation) {
        ArrayList rotatedShapes = new ArrayList();
        shape.forAllBoxes((x1, y1, z1, x2, y2, z2) -> {
            y1 = y1 * 16.0 - 8.0;
            y2 = y2 * 16.0 - 8.0;
            z1 = z1 * 16.0 - 8.0;
            z2 = z2 * 16.0 - 8.0;
            switch (rotation) {
                case 90: {
                    rotatedShapes.add(VoxelShapeUtils.boxSafe(x1 * 16.0, 8.0 - z1, 8.0 + y1, x2 * 16.0, 8.0 - z2, 8.0 + y2));
                    break;
                }
                case 180: {
                    rotatedShapes.add(VoxelShapeUtils.boxSafe(x1 * 16.0, 8.0 - z1, 8.0 - y1, x2 * 16.0, 8.0 - z2, 8.0 - y2));
                    break;
                }
                case 270: {
                    rotatedShapes.add(VoxelShapeUtils.boxSafe(x1 * 16.0, 8.0 + z1, 8.0 - y1, x2 * 16.0, 8.0 + z2, 8.0 - y2));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid rotation " + rotation + " (must be 90,180 or 270)");
                }
            }
        });
        return rotatedShapes.stream().reduce((v1, v2) -> Shapes.joinUnoptimized((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).orElse(shape).optimize();
    }

    public static VoxelShape combine(BooleanOp func, VoxelShape ... shapes) {
        return Arrays.stream(shapes).reduce((v1, v2) -> Shapes.joinUnoptimized((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)func)).orElseThrow().optimize();
    }

    public static VoxelShape or(VoxelShape ... shapes) {
        return VoxelShapeUtils.combine(BooleanOp.OR, shapes);
    }

    private static VoxelShape boxSafe(double pMinX, double pMinY, double pMinZ, double pMaxX, double pMaxY, double pMaxZ) {
        double x1 = Math.min(pMinX, pMaxX);
        double x2 = Math.max(pMinX, pMaxX);
        double y1 = Math.min(pMinY, pMaxY);
        double y2 = Math.max(pMinY, pMaxY);
        double z1 = Math.min(pMinZ, pMaxZ);
        double z2 = Math.max(pMinZ, pMaxZ);
        return Block.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }
}

