/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.tubes;

import com.mojang.datafixers.util.Either;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.JarRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public record ConnectedHandlers(List<BlockCapabilityCache<IItemHandler, Direction>> itemHandlers, List<BlockCapabilityCache<IFluidHandler, Direction>> fluidHandlers) {
    public static ConnectedHandlers create() {
        return new ConnectedHandlers(new ArrayList<BlockCapabilityCache<IItemHandler, Direction>>(), new ArrayList<BlockCapabilityCache<IFluidHandler, Direction>>());
    }

    public void checkAndAddHandlers(ServerLevel level, BlockPos pos, Direction dir) {
        if (level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)dir) != null) {
            this.itemHandlers.add((BlockCapabilityCache<IItemHandler, Direction>)BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)level, (BlockPos)pos, (Object)dir));
        }
        if (level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)dir) != null) {
            this.fluidHandlers.add((BlockCapabilityCache<IFluidHandler, Direction>)BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)level, (BlockPos)pos, (Object)dir));
        }
    }

    public ExtractionContext findIngredients(JarRecipe recipe) {
        ExtractionContext context = new ExtractionContext();
        for (Either<SizedFluidIngredient, SizedIngredient> input : recipe.allInputs()) {
            input.ifLeft(fluid -> this.findFluid((SizedFluidIngredient)fluid, context)).ifRight(item -> this.findItem((SizedIngredient)item, context));
            if (!context.isInsufficient()) continue;
            break;
        }
        return context;
    }

    public boolean distributeOutputs(BlockEntity jar, JarRecipe recipe) {
        ArrayList<ItemStack> excessItems = new ArrayList<ItemStack>();
        for (ItemStack stack : recipe.getOutputItems()) {
            int remaining = stack.getCount();
            for (BlockCapabilityCache<IItemHandler, Direction> handler : this.itemHandlers) {
                if (handler.getCapability() == null) continue;
                ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)handler.getCapability()), (ItemStack)stack.copy(), (boolean)false);
                if ((remaining -= stack.getCount() - excess.getCount()) > 0) continue;
                break;
            }
            if (remaining <= 0) continue;
            excessItems.add(stack.copy());
        }
        return false;
    }

    private void findFluid(SizedFluidIngredient ingredient, ExtractionContext context) {
        int remaining = ingredient.amount();
        for (BlockCapabilityCache<IFluidHandler, Direction> fluidCaches : this.fluidHandlers) {
            IFluidHandler handler = (IFluidHandler)fluidCaches.getCapability();
            if (handler == null) continue;
            FluidStack stack = handler.drain(remaining, IFluidHandler.FluidAction.SIMULATE);
            if (!ingredient.ingredient().test(stack)) continue;
            context.addFluidSource(handler, stack);
            if ((remaining -= stack.getAmount()) > 0) continue;
            break;
        }
        if (remaining > 0) {
            context.markInsufficient();
        }
    }

    private void findItem(SizedIngredient ingredient, ExtractionContext context) {
        int remaining = ingredient.count();
        block0: for (BlockCapabilityCache<IItemHandler, Direction> itemCaches : this.itemHandlers) {
            IItemHandler handler = (IItemHandler)itemCaches.getCapability();
            if (handler == null) continue;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.extractItem(i, remaining, true);
                if (!ingredient.ingredient().test(stack)) continue;
                context.addItemSource(handler, stack, i);
                if ((remaining -= stack.getCount()) <= 0) continue block0;
            }
        }
        if (remaining > 0) {
            context.markInsufficient();
        }
    }

    public static class ExtractionContext {
        private boolean insufficient = false;
        private final List<FluidSource> fluidSources = new ArrayList<FluidSource>();
        private final List<ItemSource> itemSources = new ArrayList<ItemSource>();

        public boolean isInsufficient() {
            return this.insufficient;
        }

        public void markInsufficient() {
            this.insufficient = true;
        }

        public void addFluidSource(IFluidHandler handler, FluidStack fluidStack) {
            this.fluidSources.add(new FluidSource(handler, fluidStack));
        }

        public void addItemSource(IItemHandler handler, ItemStack itemStack, int slot) {
            this.itemSources.add(new ItemSource(handler, itemStack, slot));
        }

        public boolean apply() {
            return true;
        }
    }

    private record ItemSource(IItemHandler handler, ItemStack itemStack, int slot) {
    }

    private record FluidSource(IFluidHandler handler, FluidStack fluidStack) {
    }
}

