/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.temperature;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbstuffnthings.FTBStuffNThings;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import org.joml.Vector3f;

public enum Temperature implements StringRepresentable
{
    NORMAL("normal", (ParticleOptions)new DustParticleOptions(new Vector3f(0.9f, 0.9f, 0.9f), 1.0f), 0.1f, ChatFormatting.GRAY),
    HOT("hot", (ParticleOptions)ParticleTypes.FLAME, 0.1f, ChatFormatting.GOLD),
    SUPERHEATED("superheated", (ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, 0.1f, ChatFormatting.AQUA),
    CHILLED("chilled", (ParticleOptions)ParticleTypes.END_ROD, 0.3f, ChatFormatting.BLUE);

    public static final Temperature[] VALUES;
    public static final Map<String, Temperature> MAP;
    private final String id;
    private final Component name;
    private final ResourceLocation texture;
    private final Icon icon;
    private final ParticleOptions particleOptions;
    private final float particleYOffset;
    private final ChatFormatting color;

    private Temperature(String id, ParticleOptions particleOptions, float particleYOffset, ChatFormatting color) {
        this.id = id;
        this.particleOptions = particleOptions;
        this.particleYOffset = particleYOffset;
        this.color = color;
        this.name = Component.translatable((String)("ftbstuff.temperature." + this.id));
        this.texture = FTBStuffNThings.id("textures/gui/temperature/" + this.id + ".png");
        this.icon = Icon.getIcon((ResourceLocation)this.texture);
    }

    public String getSerializedName() {
        return this.id;
    }

    public Component getName() {
        return this.name.copy().withStyle(this.color);
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public static Temperature byName(String name) {
        return MAP.getOrDefault(name.toLowerCase(), NORMAL);
    }

    public ParticleOptions getParticleOptions() {
        return this.particleOptions;
    }

    public float getParticleYOffset() {
        return this.particleYOffset;
    }

    static {
        VALUES = Temperature.values();
        MAP = Arrays.stream(VALUES).collect(Collectors.toMap(t -> t.id, t -> t));
    }
}

