/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.registry;

import dev.ftb.mods.ftbstuffnthings.crafting.FTBStuffRecipeType;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.CrookRecipe;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.DripperRecipe;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.FusingMachineRecipe;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.HammerRecipe;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.JarRecipe;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.SluiceRecipe;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.SuperCoolerRecipe;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.TemperatureSourceRecipe;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RecipesRegistry {
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"ftbstuff");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"ftbstuff");
    public static final Supplier<RecipeType<JarRecipe>> TEMPERED_JAR_TYPE = RecipesRegistry.registerType("jar", FTBStuffRecipeType::new);
    public static final Supplier<RecipeSerializer<JarRecipe>> TEMPERED_JAR_SERIALIZER = RECIPE_SERIALIZERS.register("jar", () -> new JarRecipe.Serializer<JarRecipe>(JarRecipe::new));
    public static final Supplier<RecipeType<TemperatureSourceRecipe>> TEMPERATURE_SOURCE_TYPE = RecipesRegistry.registerType("temperature_source", FTBStuffRecipeType::new);
    public static final Supplier<RecipeSerializer<TemperatureSourceRecipe>> TEMPERATURE_SOURCE_SERIALIZER = RECIPE_SERIALIZERS.register("temperature_source", () -> new TemperatureSourceRecipe.Serializer<TemperatureSourceRecipe>(TemperatureSourceRecipe::new));
    public static final Supplier<RecipeType<DripperRecipe>> DRIP_TYPE = RecipesRegistry.registerType("dripper", FTBStuffRecipeType::new);
    public static final Supplier<RecipeSerializer<DripperRecipe>> DRIP_SERIALIZER = RECIPE_SERIALIZERS.register("dripper", () -> new DripperRecipe.Serializer<DripperRecipe>(DripperRecipe::new));
    public static final Supplier<RecipeType<CrookRecipe>> CROOK_TYPE = RecipesRegistry.registerType("crook", FTBStuffRecipeType::new);
    public static final Supplier<RecipeSerializer<CrookRecipe>> CROOK_SERIALIZER = RECIPE_SERIALIZERS.register("crook", () -> new CrookRecipe.Serializer<CrookRecipe>(CrookRecipe::new));
    public static final Supplier<RecipeType<SluiceRecipe>> SLUICE_TYPE = RecipesRegistry.registerType("sluice", FTBStuffRecipeType::new);
    public static final Supplier<RecipeSerializer<SluiceRecipe>> SLUICE_SERIALIZER = RECIPE_SERIALIZERS.register("sluice", () -> new SluiceRecipe.Serializer<SluiceRecipe>(SluiceRecipe::new));
    public static final Supplier<RecipeType<HammerRecipe>> HAMMER_TYPE = RecipesRegistry.registerType("hammer", FTBStuffRecipeType::new);
    public static final Supplier<RecipeSerializer<HammerRecipe>> HAMMER_SERIALIZER = RECIPE_SERIALIZERS.register("hammer", () -> new HammerRecipe.Serializer<HammerRecipe>(HammerRecipe::new));
    public static final Supplier<RecipeType<FusingMachineRecipe>> FUSING_MACHINE_TYPE = RecipesRegistry.registerType("fusing_machine", FTBStuffRecipeType::new);
    public static final Supplier<RecipeSerializer<FusingMachineRecipe>> FUSING_MACHINE_SERIALIZER = RECIPE_SERIALIZERS.register("fusing_machine", () -> new FusingMachineRecipe.Serializer<FusingMachineRecipe>(FusingMachineRecipe::new));
    public static final Supplier<RecipeType<SuperCoolerRecipe>> SUPER_COOLER_TYPE = RecipesRegistry.registerType("supercooler", FTBStuffRecipeType::new);
    public static final Supplier<RecipeSerializer<SuperCoolerRecipe>> SUPER_COOLER_SERIALIZER = RECIPE_SERIALIZERS.register("supercooler", () -> new SuperCoolerRecipe.Serializer<SuperCoolerRecipe>(SuperCoolerRecipe::new));

    public static void init(IEventBus bus) {
        RECIPE_TYPES.register(bus);
        RECIPE_SERIALIZERS.register(bus);
    }

    private static <T extends RecipeType<?>> Supplier<T> registerType(String name, Function<String, T> factory) {
        return RECIPE_TYPES.register(name, () -> (RecipeType)factory.apply(name));
    }
}

