/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.registry;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ComponentsRegistry {
    private static final DeferredRegister.DataComponents COMPONENTS = DeferredRegister.createDataComponents((String)"ftbstuff");
    public static final Supplier<DataComponentType<SimpleFluidContent>> STORED_FLUID = ComponentsRegistry.register("stored_fluid", SimpleFluidContent.CODEC, SimpleFluidContent.STREAM_CODEC);
    public static final Supplier<DataComponentType<List<SimpleFluidContent>>> FLUID_TANKS = ComponentsRegistry.register("fluid_tanks", SimpleFluidContent.CODEC.listOf(), SimpleFluidContent.STREAM_CODEC.apply(ByteBufCodecs.list()));
    public static final Supplier<DataComponentType<Integer>> STORED_ENERGY = ComponentsRegistry.register("energy", Codec.INT, ByteBufCodecs.INT);

    public static void init(IEventBus eventBus) {
        COMPONENTS.register(eventBus);
    }

    private static <T> Supplier<DataComponentType<T>> register(String name, Codec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec) {
        return COMPONENTS.registerComponentType(name, builder -> builder.persistent(codec).networkSynchronized(streamCodec));
    }
}

