/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.network;

import com.mojang.datafixers.util.Either;
import dev.ftb.mods.ftbstuffnthings.FTBStuffNThings;
import dev.ftb.mods.ftbstuffnthings.blocks.jar.TemperedJarBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncJarContentsPacket(BlockPos jarPos, List<ResourceSlot> resources) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncJarContentsPacket> TYPE = new CustomPacketPayload.Type(FTBStuffNThings.id("sync_jar_fluids"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncJarContentsPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SyncJarContentsPacket::jarPos, (StreamCodec)ResourceSlot.STREAM_CODEC.apply(ByteBufCodecs.list()), SyncJarContentsPacket::resources, SyncJarContentsPacket::new);

    public static SyncJarContentsPacket wholeJar(TemperedJarBlockEntity jar) {
        ItemStack stack;
        int i;
        ArrayList<ResourceSlot> resources = new ArrayList<ResourceSlot>();
        for (i = 0; i < jar.getInputItemHandler().getSlots(); ++i) {
            stack = jar.getInputItemHandler().getStackInSlot(i);
            if (stack.isEmpty()) continue;
            resources.add(new ResourceSlot(i, (Either<ItemStack, FluidStack>)Either.left((Object)stack)));
        }
        for (i = 0; i < jar.getFluidHandler().getTanks(); ++i) {
            stack = jar.getFluidHandler().getFluidInTank(i);
            if (stack.isEmpty()) continue;
            resources.add(new ResourceSlot(i, (Either<ItemStack, FluidStack>)Either.right((Object)stack)));
        }
        return new SyncJarContentsPacket(jar.getBlockPos(), resources);
    }

    public static SyncJarContentsPacket oneItem(BlockPos pos, int slot, ItemStack stack) {
        return new SyncJarContentsPacket(pos, List.of(new ResourceSlot(slot, (Either<ItemStack, FluidStack>)Either.left((Object)stack))));
    }

    public static SyncJarContentsPacket oneFluid(BlockPos pos, int slot, FluidStack stack) {
        return new SyncJarContentsPacket(pos, List.of(new ResourceSlot(slot, (Either<ItemStack, FluidStack>)Either.right((Object)stack))));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleData(SyncJarContentsPacket packet, IPayloadContext context) {
        BlockEntity blockEntity = context.player().level().getBlockEntity(packet.jarPos);
        if (blockEntity instanceof TemperedJarBlockEntity) {
            TemperedJarBlockEntity jar = (TemperedJarBlockEntity)blockEntity;
            jar.syncFromServer(packet.resources);
        }
    }

    public record ResourceSlot(int slot, Either<ItemStack, FluidStack> resource) {
        public static final StreamCodec<RegistryFriendlyByteBuf, ResourceSlot> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ResourceSlot::slot, (StreamCodec)ByteBufCodecs.either((StreamCodec)ItemStack.STREAM_CODEC, (StreamCodec)FluidStack.STREAM_CODEC), ResourceSlot::resource, ResourceSlot::new);
    }
}

