/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.lootmodifiers;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbstuffnthings.FTBStuffTags;
import dev.ftb.mods.ftbstuffnthings.crafting.ToolsRecipeCache;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class HammerModifier
extends LootModifier {
    public static final Supplier<MapCodec<HammerModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(builder -> HammerModifier.codecStart((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, HammerModifier::new)));

    public HammerModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> list, LootContext context) {
        ItemStack hammer = (ItemStack)context.getParamOrNull(LootContextParams.TOOL);
        Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        BlockState blockState = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        if (!(entity instanceof Player && hammer != null && blockState != null && hammer.is(FTBStuffTags.Items.HAMMERS) && ToolsRecipeCache.hammerable(blockState))) {
            return list;
        }
        List<ItemStack> hammerDrops = ToolsRecipeCache.getHammerDrops(entity.level(), new ItemStack((ItemLike)blockState.getBlock()));
        if (!hammerDrops.isEmpty()) {
            list.clear();
            hammerDrops.stream().map(ItemStack::copy).forEach(arg_0 -> list.add(arg_0));
        }
        return list;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

