/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.lootmodifiers;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbstuffnthings.FTBStuffTags;
import dev.ftb.mods.ftbstuffnthings.crafting.ToolsRecipeCache;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.CrookRecipe;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class CrookModifier
extends LootModifier {
    public static final Supplier<MapCodec<CrookModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(builder -> CrookModifier.codecStart((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, CrookModifier::new)));

    public CrookModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> list, LootContext context) {
        int maxDrops;
        ItemStack crook = (ItemStack)context.getParamOrNull(LootContextParams.TOOL);
        Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        BlockState blockState = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        if (!(entity instanceof Player && crook != null && blockState != null && crook.is(FTBStuffTags.Items.CROOKS) && ToolsRecipeCache.crookable(blockState))) {
            return list;
        }
        CrookRecipe.CrookDrops crookDrops = ToolsRecipeCache.getCrookDrops(entity.level(), new ItemStack((ItemLike)blockState.getBlock()));
        int n = maxDrops = crookDrops.max() <= 0 ? Integer.MAX_VALUE : crookDrops.max();
        if (!crookDrops.items().isEmpty()) {
            RandomSource random = context.getRandom();
            List collect = crookDrops.items().stream().filter(itemWithChance -> (double)random.nextFloat() < itemWithChance.chance()).map(itemWithChance -> itemWithChance.item().copy()).collect(Collectors.toList());
            Collections.shuffle(collect);
            if (crookDrops.replaceDrops()) {
                list.clear();
            }
            collect.stream().limit(maxDrops).forEach(arg_0 -> list.add(arg_0));
        }
        return list;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

