/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.integration.jei;

import dev.ftb.mods.ftbstuffnthings.util.lootsummary.LootSummary;
import dev.ftb.mods.ftbstuffnthings.util.lootsummary.LootSummaryCollection;
import dev.ftb.mods.ftbstuffnthings.util.lootsummary.WrappedLootSummary;
import java.util.List;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public enum LootSummaryPlugin implements ISimpleRecipeManagerPlugin<WrappedLootSummary>
{
    INSTANCE;

    @NotNull
    private static final List<WrappedLootSummary> NONE;

    public boolean isHandledInput(ITypedIngredient<?> input) {
        return input.getItemStack().map(stack -> LootSummaryCollection.getClientSummary().getLootSummaryForInput(Block.byItem((Item)stack.getItem())).isPresent()).orElse(false);
    }

    public boolean isHandledOutput(ITypedIngredient<?> output) {
        return output.getItemStack().map(stack -> !LootSummaryCollection.getClientSummary().getLootSummariesForOutput((ItemStack)stack).isEmpty()).orElse(false);
    }

    public List<WrappedLootSummary> getRecipesForInput(ITypedIngredient<?> input) {
        return input.getItemStack().map(LootSummaryPlugin::getWrappedLootSummariesForStack).orElse(NONE);
    }

    public List<WrappedLootSummary> getRecipesForOutput(ITypedIngredient<?> output) {
        return output.getItemStack().map(stack -> LootSummaryCollection.getClientSummary().getLootSummariesForOutput((ItemStack)stack)).orElse(List.of());
    }

    public List<WrappedLootSummary> getAllRecipes() {
        return LootSummaryCollection.getClientSummary().getLootSummariesForOutput(ItemStack.EMPTY);
    }

    @NotNull
    private static List<WrappedLootSummary> getWrappedLootSummariesForStack(ItemStack stack) {
        Block block = Block.byItem((Item)stack.getItem());
        if (block == Blocks.AIR) {
            return NONE;
        }
        return LootSummaryCollection.getClientSummary().getLootSummaryForInput(block).map(summary -> List.of(new WrappedLootSummary(block, (LootSummary)summary))).orElse(NONE);
    }

    static {
        NONE = List.of();
    }
}

