/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbstuffnthings.integration.jei.BaseStuffCategory;
import dev.ftb.mods.ftbstuffnthings.integration.jei.RecipeTypes;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import dev.ftb.mods.ftbstuffnthings.util.lootsummary.LootSummary;
import dev.ftb.mods.ftbstuffnthings.util.lootsummary.WrappedLootSummary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.mutable.MutableInt;

public class LootSummaryCategory
extends BaseStuffCategory<WrappedLootSummary> {
    private static final ChatFormatting[] POOL_COLS = new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.YELLOW, ChatFormatting.AQUA, ChatFormatting.GREEN, ChatFormatting.LIGHT_PURPLE, ChatFormatting.GOLD};
    public static final int MAX_DISPLAYABLE_IDX = 34;
    private int nItems;

    public LootSummaryCategory() {
        super(RecipeTypes.LOOT_SUMMARY, (Component)Component.translatable((String)"ftbstuff.jei.loot_summary"), (IDrawable)LootSummaryCategory.guiHelper().drawableBuilder(LootSummaryCategory.bgTexture("jei_loot_table.png"), 0, 0, 156, 126).setTextureSize(180, 126).build(), LootSummaryCategory.guiHelper().createDrawableItemStack(ItemsRegistry.CRATE.toStack()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WrappedLootSummary recipe, IFocusGroup focuses) {
        this.nItems = 0;
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 5).addItemStack(recipe.inputStack().asItem().getDefaultInstance());
        Map<String, List<LootSummary.SummaryEntry>> poolMap = recipe.summary().entryMap();
        int nPools = poolMap.keySet().size();
        HashMap<String, Integer> pool2idx = new HashMap<String, Integer>();
        int n = 0;
        for (Map.Entry<String, List<LootSummary.SummaryEntry>> entry : poolMap.entrySet()) {
            pool2idx.put(entry.getKey(), n++);
        }
        MutableInt poolIdx = new MutableInt(0);
        for (Map.Entry<String, List<LootSummary.SummaryEntry>> entry : poolMap.entrySet()) {
            String poolName = entry.getKey();
            for (LootSummary.SummaryEntry summaryEntry : entry.getValue()) {
                if (summaryEntry.stack().isEmpty()) continue;
                if (this.nItems <= 34) {
                    ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 28 + this.nItems % 7 * 18, 5 + this.nItems / 7 * 24).addItemStack(summaryEntry.stack())).addRichTooltipCallback((recipeSlotView, tooltip) -> {
                        if (nPools > 1) {
                            MutableComponent poolComp = Component.literal((String)poolName).withStyle(LootSummaryCategory.poolColor(pool2idx.getOrDefault(poolName, 0)));
                            tooltip.add((FormattedText)Component.translatable((String)"ftbstuff.jei.loot_summary.pool", (Object[])new Object[]{poolComp}).withStyle(ChatFormatting.GRAY));
                        }
                    });
                }
                ++this.nItems;
            }
            poolIdx.increment();
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, WrappedLootSummary recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        super.getTooltip(tooltip, (Object)recipe, recipeSlotsView, mouseX, mouseY);
        Map<String, List<LootSummary.SummaryEntry>> entryMap = recipe.summary().entryMap();
        int nPools = entryMap.keySet().size();
        if (nPools > 1 && mouseX >= 5.0 && mouseX <= 21.0 && mouseY >= 25.0 && mouseY <= 41.0) {
            tooltip.add((FormattedText)Component.translatable((String)"ftbstuff.jei.loot_summary.pool_header", (Object[])new Object[]{nPools}));
            int i = 0;
            for (String pool : entryMap.keySet()) {
                tooltip.add((FormattedText)Component.literal((String)("\u2588 " + pool)).withStyle(LootSummaryCategory.poolColor(i)));
                ++i;
            }
        }
        if (mouseX >= 5.0 && mouseX <= 21.0 && mouseY >= 110.0 && mouseY <= 126.0) {
            tooltip.add((FormattedText)Component.translatable((String)"ftbstuff.jei.loot_summary.too_many", (Object[])new Object[]{this.nItems - 34 + 1}));
        }
    }

    @Override
    public void draw(WrappedLootSummary recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        Map<String, List<LootSummary.SummaryEntry>> poolMap = recipe.summary().entryMap();
        if (poolMap.keySet().size() > 1) {
            guiGraphics.blit(ResourceLocation.parse((String)"ftblibrary:textures/icons/info.png"), 5, 25, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        if (this.nItems >= 34) {
            guiGraphics.blit(ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/icon/unseen_notification.png"), 5, 110, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        int idx = 0;
        int poolIdx = 0;
        for (List<LootSummary.SummaryEntry> entryList : poolMap.values()) {
            for (LootSummary.SummaryEntry summaryEntry : entryList) {
                if (summaryEntry.stack().isEmpty()) continue;
                PoseStack stack = guiGraphics.pose();
                stack.pushPose();
                stack.translate((float)(36 + idx % 7 * 18), 23.5f + (float)(idx / 7 * 24), 100.0f);
                stack.scale(0.5f, 0.5f, 1.0f);
                String weightStr = String.format("%.2f%%", Float.valueOf(summaryEntry.weight() * 100.0f));
                guiGraphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.literal((String)weightStr).withStyle(LootSummaryCategory.poolColor(poolIdx)), 0, 0, 0xFFFFFF);
                stack.popPose();
                if (idx++ < 34) continue;
                return;
            }
            ++poolIdx;
        }
    }

    static ChatFormatting poolColor(int n) {
        return POOL_COLS[n % POOL_COLS.length];
    }
}

