/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbstuffnthings.client.screens.FusingMachineScreen;
import dev.ftb.mods.ftbstuffnthings.crafting.EnergyComponent;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.FusingMachineRecipe;
import dev.ftb.mods.ftbstuffnthings.integration.jei.BaseStuffCategory;
import dev.ftb.mods.ftbstuffnthings.integration.jei.RecipeTypes;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;

public class FusingMachineCategory
extends BaseStuffCategory<FusingMachineRecipe> {
    public static final ResourceLocation BACKGROUND = FusingMachineCategory.bgTexture("jei_fusing_machine.png");
    private static final Rect2i CLICK_AREA = new Rect2i(89, 26, 26, 19);
    private final IDrawableAnimated powerBar = FusingMachineCategory.guiHelper().drawableBuilder(BACKGROUND, 106, 0, 6, 16).setTextureSize(134, 28).buildAnimated(FusingMachineCategory.guiHelper().createTickTimer(120, 16, false), IDrawableAnimated.StartDirection.BOTTOM);
    private final IDrawableAnimated progress = FusingMachineCategory.guiHelper().drawableBuilder(BACKGROUND, 112, 0, 22, 16).setTextureSize(134, 28).buildAnimated(FusingMachineCategory.guiHelper().createTickTimer(120, 22, true), IDrawableAnimated.StartDirection.LEFT);

    public FusingMachineCategory() {
        super(RecipeTypes.FUSING_MACHINE, (Component)Component.translatable((String)"block.ftbstuff.fusing_machine"), (IDrawable)FusingMachineCategory.guiHelper().drawableBuilder(BACKGROUND, 0, 0, 106, 28).setTextureSize(134, 28).build(), FusingMachineCategory.guiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((BlockItem)ItemsRegistry.FUSING_MACHINE.get()).getDefaultInstance()));
    }

    @Override
    public void draw(FusingMachineRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, graphics, mouseX, mouseY);
        this.powerBar.draw(graphics, 6, 6);
        this.progress.draw(graphics, 57, 6);
        PoseStack stack = graphics.pose();
        stack.pushPose();
        stack.translate(5.0f, 25.0f, 0.0f);
        stack.scale(0.5f, 0.5f, 0.5f);
        EnergyComponent energyComponent = recipe.getEnergyComponent();
        int ticks = energyComponent.ticksToProcess();
        int energyPerTick = energyComponent.fePerTick();
        int totalEnergy = ticks * energyPerTick;
        graphics.drawString(Minecraft.getInstance().font, "%sFE/t (%sFE)".formatted(energyPerTick, totalEnergy), 0, 0, 0x404040, false);
        stack.popPose();
        stack.pushPose();
        stack.translate(83.0f, 25.0f, 0.0f);
        stack.scale(0.5f, 0.5f, 0.5f);
        graphics.drawString(Minecraft.getInstance().font, "%s ticks".formatted(ticks), 0, 0, 0x404040, false);
        stack.popPose();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FusingMachineRecipe fusingRecipe, IFocusGroup iFocusGroup) {
        for (int i = 0; i < fusingRecipe.getInputs().size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, 18 + i * 18, 6).addIngredients(fusingRecipe.getInputs().get(i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 84, 6).addFluidStack(fusingRecipe.getFluidResult().getFluid(), (long)fusingRecipe.getFluidResult().getAmount()).addRichTooltipCallback((recipeSlotView, tooltip) -> tooltip.add((FormattedText)Component.literal((String)(fusingRecipe.getFluidResult().getAmount() + " mB"))));
    }

    static enum ContainerHandler implements IGuiContainerHandler<FusingMachineScreen>
    {
        INSTANCE;


        public Collection<IGuiClickableArea> getGuiClickableAreas(FusingMachineScreen containerScreen, double guiMouseX, double guiMouseY) {
            return List.of(IGuiClickableArea.createBasic((int)CLICK_AREA.getX(), (int)CLICK_AREA.getY(), (int)CLICK_AREA.getWidth(), (int)CLICK_AREA.getHeight(), (RecipeType[])new RecipeType[]{RecipeTypes.FUSING_MACHINE}));
        }
    }
}

