/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.integration.jei;

import com.mojang.serialization.Codec;
import dev.ftb.mods.ftbstuffnthings.FTBStuffNThings;
import dev.ftb.mods.ftbstuffnthings.client.screens.FusingMachineScreen;
import dev.ftb.mods.ftbstuffnthings.client.screens.SuperCoolerScreen;
import dev.ftb.mods.ftbstuffnthings.client.screens.TemperedJarScreen;
import dev.ftb.mods.ftbstuffnthings.crafting.IHideableRecipe;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.TemperatureSourceRecipe;
import dev.ftb.mods.ftbstuffnthings.integration.jei.CrookCategory;
import dev.ftb.mods.ftbstuffnthings.integration.jei.DripperCategory;
import dev.ftb.mods.ftbstuffnthings.integration.jei.FTBStuffIngredientTypes;
import dev.ftb.mods.ftbstuffnthings.integration.jei.FusingMachineCategory;
import dev.ftb.mods.ftbstuffnthings.integration.jei.HammerCategory;
import dev.ftb.mods.ftbstuffnthings.integration.jei.LootSummaryCategory;
import dev.ftb.mods.ftbstuffnthings.integration.jei.LootSummaryPlugin;
import dev.ftb.mods.ftbstuffnthings.integration.jei.RecipeTypes;
import dev.ftb.mods.ftbstuffnthings.integration.jei.SluiceCategory;
import dev.ftb.mods.ftbstuffnthings.integration.jei.SuperCoolerCategory;
import dev.ftb.mods.ftbstuffnthings.integration.jei.TemperatureHelper;
import dev.ftb.mods.ftbstuffnthings.integration.jei.TemperatureRenderer;
import dev.ftb.mods.ftbstuffnthings.integration.jei.TemperatureSourceCategory;
import dev.ftb.mods.ftbstuffnthings.integration.jei.TemperedJarCategory;
import dev.ftb.mods.ftbstuffnthings.items.HammerItem;
import dev.ftb.mods.ftbstuffnthings.registry.BlocksRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import dev.ftb.mods.ftbstuffnthings.temperature.Temperature;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

@JeiPlugin
public class FTBStuffJeiPlugin
implements IModPlugin {
    static IJeiHelpers jeiHelpers;
    static IRecipeManager recipeManager;
    static IRecipesGui recipesGui;

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        recipeManager = jeiRuntime.getRecipeManager();
        recipesGui = jeiRuntime.getRecipesGui();
        jeiRuntime.getIngredientManager().addIngredientsAtRuntime(FTBStuffIngredientTypes.TEMPERATURE, Arrays.asList(Temperature.values()));
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(FTBStuffIngredientTypes.TEMPERATURE, Arrays.asList(Temperature.values()), (IIngredientHelper)TemperatureHelper.INSTANCE, (IIngredientRenderer)TemperatureRenderer.INSTANCE, (Codec)StringRepresentable.fromEnum(Temperature::values));
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        jeiHelpers = registration.getJeiHelpers();
        registration.addRecipeCategories(new IRecipeCategory[]{new TemperedJarCategory(), new TemperatureSourceCategory(), new DripperCategory(), new HammerCategory(), new FusingMachineCategory(), new SuperCoolerCategory(), new CrookCategory(), new SluiceCategory(), new LootSummaryCategory()});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.addRecipeType(registration, RecipesRegistry.TEMPERED_JAR_TYPE.get(), RecipeTypes.TEMPERED_JAR, TemperedJarCategory::sortRecipes);
        this.addRecipeType(registration, RecipesRegistry.TEMPERATURE_SOURCE_TYPE.get(), RecipeTypes.TEMPERATURE_SOURCE, TemperatureSourceRecipe::sortRecipes);
        this.addRecipeType(registration, RecipesRegistry.DRIP_TYPE.get(), RecipeTypes.DRIPPER);
        this.addRecipeType(registration, RecipesRegistry.CROOK_TYPE.get(), RecipeTypes.CROOK);
        this.addRecipeType(registration, RecipesRegistry.HAMMER_TYPE.get(), RecipeTypes.HAMMER);
        this.addRecipeType(registration, RecipesRegistry.FUSING_MACHINE_TYPE.get(), RecipeTypes.FUSING_MACHINE);
        this.addRecipeType(registration, RecipesRegistry.SUPER_COOLER_TYPE.get(), RecipeTypes.SUPER_COOLER);
        this.addRecipeType(registration, RecipesRegistry.SLUICE_TYPE.get(), RecipeTypes.SLUICE);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(ItemsRegistry.TEMPERED_JAR.toStack(), new RecipeType[]{RecipeTypes.TEMPERED_JAR});
        registration.addRecipeCatalyst(ItemsRegistry.CREATIVE_HOT_TEMPERATURE_SOURCE.toStack(), new RecipeType[]{RecipeTypes.TEMPERATURE_SOURCE});
        registration.addRecipeCatalyst(ItemsRegistry.CREATIVE_SUPERHEATED_TEMPERATURE_SOURCE.toStack(), new RecipeType[]{RecipeTypes.TEMPERATURE_SOURCE});
        registration.addRecipeCatalyst(ItemsRegistry.CREATIVE_CHILLED_TEMPERATURE_SOURCE.toStack(), new RecipeType[]{RecipeTypes.TEMPERATURE_SOURCE});
        registration.addRecipeCatalyst(ItemsRegistry.CROOK.toStack(), new RecipeType[]{RecipeTypes.CROOK});
        registration.addRecipeCatalyst(ItemsRegistry.DRIPPER.toStack(), new RecipeType[]{RecipeTypes.DRIPPER});
        registration.addRecipeCatalyst(ItemsRegistry.FUSING_MACHINE.toStack(), new RecipeType[]{RecipeTypes.FUSING_MACHINE});
        registration.addRecipeCatalyst(ItemsRegistry.SUPER_COOLER.toStack(), new RecipeType[]{RecipeTypes.SUPER_COOLER});
        for (DeferredItem<HammerItem> deferredItem : ItemsRegistry.ALL_HAMMERS) {
            registration.addRecipeCatalyst(deferredItem.toStack(), new RecipeType[]{RecipeTypes.HAMMER});
        }
        for (DeferredBlock deferredBlock : BlocksRegistry.ALL_AUTO_HAMMERS) {
            registration.addRecipeCatalyst(deferredBlock.toStack(), new RecipeType[]{RecipeTypes.HAMMER});
        }
        for (DeferredBlock deferredBlock : BlocksRegistry.ALL_SLUICES) {
            registration.addRecipeCatalyst(deferredBlock.toStack(), new RecipeType[]{RecipeTypes.SLUICE});
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(TemperedJarScreen.class, (IGuiContainerHandler)TemperedJarCategory.ContainerHandler.INSTANCE);
        registration.addGuiContainerHandler(FusingMachineScreen.class, (IGuiContainerHandler)FusingMachineCategory.ContainerHandler.INSTANCE);
        registration.addGuiContainerHandler(SuperCoolerScreen.class, (IGuiContainerHandler)SuperCoolerCategory.ContainerHandler.INSTANCE);
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        registration.addTypedRecipeManagerPlugin(RecipeTypes.LOOT_SUMMARY, (ISimpleRecipeManagerPlugin)LootSummaryPlugin.INSTANCE);
    }

    public ResourceLocation getPluginUid() {
        return FTBStuffNThings.id("jei_plugin");
    }

    private <I extends RecipeInput, T extends Recipe<I>> void addRecipeType(IRecipeRegistration registration, net.minecraft.world.item.crafting.RecipeType<T> mcRecipeType, RecipeType<T> jeiRecipeType) {
        this.addRecipeType(registration, mcRecipeType, jeiRecipeType, Function.identity());
    }

    private <I extends RecipeInput, T extends Recipe<I>> void addRecipeType(IRecipeRegistration registration, net.minecraft.world.item.crafting.RecipeType<T> mcRecipeType, RecipeType<T> jeiRecipeType, Function<List<T>, List<T>> postProcessor) {
        List<Recipe> recipes = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(mcRecipeType).stream().map(RecipeHolder::value).filter(IHideableRecipe::shouldShow).toList();
        registration.addRecipes(jeiRecipeType, postProcessor.apply(recipes));
    }
}

