/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.data;

import dev.ftb.mods.ftbstuffnthings.FTBStuffTags;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class ItemTagsGenerator
extends ItemTagsProvider {
    public ItemTagsGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTags, "ftbstuff", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.appendToTag((TagKey<Item>)Tags.Items.INGOTS, FTBStuffTags.Items.INGOTS_CAST_IRON);
        this.appendToTag((TagKey<Item>)Tags.Items.NUGGETS, FTBStuffTags.Items.NUGGETS_CAST_IRON);
        this.addItemsToTag(FTBStuffTags.Items.NUGGETS_CAST_IRON, new Supplier[]{ItemsRegistry.CAST_IRON_NUGGET});
        this.addItemsToTag(FTBStuffTags.Items.INGOTS_CAST_IRON, new Supplier[]{ItemsRegistry.CAST_IRON_INGOT});
        this.addItemsToTag(FTBStuffTags.Items.GEARS, new Supplier[]{ItemsRegistry.CAST_IRON_GEAR});
        this.addItemsToTag(FTBStuffTags.Items.HAMMERS, new Supplier[]{ItemsRegistry.STONE_HAMMER, ItemsRegistry.IRON_HAMMER, ItemsRegistry.GOLD_HAMMER, ItemsRegistry.DIAMOND_HAMMER, ItemsRegistry.NETHERITE_HAMMER});
        this.addItemsToTag(FTBStuffTags.Items.CROOKS, new Supplier[]{ItemsRegistry.CROOK});
        this.addItemsToTag(FTBStuffTags.Items.MESHES, new Supplier[]{ItemsRegistry.CLOTH_MESH, ItemsRegistry.IRON_MESH, ItemsRegistry.GOLD_MESH, ItemsRegistry.DIAMOND_MESH, ItemsRegistry.BLAZING_MESH});
    }

    @SafeVarargs
    private void addItemsToTag(TagKey<Item> tag, Supplier<? extends ItemLike> ... items) {
        this.tag(tag).add((Object[])((Item[])Arrays.stream(items).map(Supplier::get).map(ItemLike::asItem).toArray(Item[]::new)));
    }

    @SafeVarargs
    private void appendToTag(TagKey<Item> tag, TagKey<Item> ... toAppend) {
        this.tag(tag).addTags(toAppend);
    }

    public String getName() {
        return "ftbstuff Item Tags";
    }
}

