/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.data;

import dev.ftb.mods.ftbstuffnthings.registry.BlocksRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredBlock;

public class I18nGenerator
extends LanguageProvider {
    private static final String[] COMPRESSED_PREFIXES = new String[]{"", "Double ", "Triple "};
    private static final Map<String, String> COMPRESSED_BLOCKS = (Map)Util.make(new HashMap(), map -> map.put("sand", "Sand"));

    public I18nGenerator(PackOutput output) {
        super(output, "ftbstuff", "en_us");
    }

    protected void addTranslations() {
        this.add("ftbstuff.itemGroup.tab", "FTB Stuff & Things");
        this.add("ftbstuff.any_block", "Any Block");
        this.add("ftbstuff.efficiency", "Efficiency: %s");
        this.add("ftbstuff.temperature", "Temperature: %s");
        this.add("ftbstuff.fluid_usage", "Uses: %s mB");
        this.add("ftbstuff.temperature.normal", "Normal");
        this.add("ftbstuff.temperature.hot", "Hot");
        this.add("ftbstuff.temperature.superheated", "Superheated");
        this.add("ftbstuff.temperature.chilled", "Chilled");
        this.add("ftbstuff.processing_time", "Processing time: %d sec");
        this.add("ftbstuff.start_mix", "Mix");
        this.add("ftbstuff.stop_mix", "Stop");
        this.add("ftbstuff.temperature_source", "Temperature Source");
        this.add("ftbstuff.temperature_source.click", "Click to show Temperature Sources");
        this.add("ftbstuff.jar_status.ready", "Ready To Craft");
        this.add("ftbstuff.jar_status.no_recipe", "No Recipe");
        this.add("ftbstuff.jar_status.not_enough_resources", "Insufficient Resources");
        this.add("ftbstuff.jar_status.output_full", "Output Full");
        this.add("ftbstuff.jar_status.crafting", "Crafting!");
        this.add("ftbstuff.making", "Making:");
        this.add("ftbstuff.dripper.chance", "Chance: %s%% / sec");
        this.add("ftbstuff.dripper.consume_on_fail", "Fluid is consumed even on failed attempt");
        this.add("ftbstuff.tooltip.hammers", "Crushes materials down to their core components");
        this.add("ftbstuff.tooltip.energy", "Energy: %s FE");
        this.add("ftbstuff.tooltip.fluid", "Fluid: %smB %s");
        this.add("ftbstuff.crook.limit", "Max drops per block broken: %s");
        this.add("ftbstuff.sluice", "Sluice");
        this.add("ftbstuff.strainer.empty", "Water Strainer is empty!");
        this.add("ftbstuff.wrong_mesh", "This Mesh doesn't fit in this Sluice!");
        this.add("ftbstuff.jade.processing", "Processing");
        this.add("ftbstuff.jade.buffer", "Buffer");
        this.add("ftbstuff.jade.time_left", "Time Left: %s");
        this.add("ftbstuff.jei.loot_summary", "Loot Table Information");
        this.add("ftbstuff.jei.loot_summary.pool", "Pool: %s");
        this.add("ftbstuff.jei.loot_summary.pool_header", "Loot table has %d loot pools:");
        this.add("ftbstuff.jei.loot_summary.too_many", "%s more loot entries are not displayed");
        this.add("config.jade.plugin_ftbstuff.autohammer", "Autohammer");
        this.add("config.jade.plugin_ftbstuff.pump", "Pump");
        this.add("block.ftbstuff.fusing_machine.tooltip", "Used to fuse items together to produce new results");
        this.add("block.ftbstuff.super_cooler.tooltip", "Used to \"super\"-cool items to produce new results");
        this.add("death.attack.static_electric", "%1$s was killed by static electricity");
        this.add("ftbstuff.advancement.root", "FTB Stuff & Things");
        this.add("ftbstuff.advancement.root.desc", "Just a collection of useful stuff... and things");
        this.add("ftbstuff.advancement.supercharged", "Supercharged");
        this.add("ftbstuff.advancement.supercharged.desc", "Over-wind a Pump and suffer the consequences");
        this.add("ftbstuff.hold_shift", "Hold Shift for more info");
        this.add("ftbstuff.sluice.props.processing_time", "Processing Time: %sx");
        this.add("ftbstuff.sluice.props.fluid_usage", "Fluid Usage Multiplier: %sx");
        this.add("ftbstuff.sluice.props.tank", "Fluid Tank Capacity: %smB");
        this.add("ftbstuff.sluice.props.auto", "Allows automation of: %s | %s");
        this.add("ftbstuff.sluice.props.auto.fluid", "Fluids");
        this.add("ftbstuff.sluice.props.auto.item", "Items");
        this.add("ftbstuff.autohammer.waiting", "Waiting...");
        this.add("ftbstuff.autohammer.running", "Running");
        this.addBlock((Supplier)BlocksRegistry.OAK_SLUICE, "Oak Sluice");
        this.addBlock((Supplier)BlocksRegistry.IRON_SLUICE, "Iron Sluice");
        this.addBlock((Supplier)BlocksRegistry.DIAMOND_SLUICE, "Diamond Sluice");
        this.addBlock((Supplier)BlocksRegistry.NETHERITE_SLUICE, "Netherite Sluice");
        this.addBlock((Supplier)BlocksRegistry.IRON_AUTO_HAMMER, "Iron Auto-Hammer");
        this.addBlock((Supplier)BlocksRegistry.GOLD_AUTO_HAMMER, "Gold Auto-Hammer");
        this.addBlock((Supplier)BlocksRegistry.DIAMOND_AUTO_HAMMER, "Diamond Auto-Hammer");
        this.addBlock((Supplier)BlocksRegistry.NETHERITE_AUTO_HAMMER, "Netherite Auto-Hammer");
        this.addBlock((Supplier)BlocksRegistry.STONE_COBBLESTONE_GENERATOR, "Stone Cobble Generator");
        this.addBlock((Supplier)BlocksRegistry.IRON_COBBLESTONE_GENERATOR, "Iron Cobble Generator");
        this.addBlock((Supplier)BlocksRegistry.GOLD_COBBLESTONE_GENERATOR, "Gold Cobble Generator");
        this.addBlock((Supplier)BlocksRegistry.DIAMOND_COBBLESTONE_GENERATOR, "Diamond Cobble Generator");
        this.addBlock((Supplier)BlocksRegistry.NETHERITE_COBBLESTONE_GENERATOR, "Netherite Cobble Generator");
        this.addBlock((Supplier)BlocksRegistry.FUSING_MACHINE, "SlowMelter 9000");
        this.addBlock((Supplier)BlocksRegistry.SUPER_COOLER, "\"Super\" Cooler");
        this.addBlock((Supplier)BlocksRegistry.PUMP, "Pump");
        this.addBlock((Supplier)BlocksRegistry.DRIPPER, "Dripper");
        this.addBlock((Supplier)BlocksRegistry.ACACIA_STRAINER, "Acacia Water Strainer");
        this.addBlock((Supplier)BlocksRegistry.BAMBOO_STRAINER, "Bamboo Water Strainer");
        this.addBlock((Supplier)BlocksRegistry.BIRCH_STRAINER, "Birch Water Strainer");
        this.addBlock((Supplier)BlocksRegistry.CHERRY_STRAINER, "Cherry Water Strainer");
        this.addBlock((Supplier)BlocksRegistry.CRIMSON_STRAINER, "Crimson Water Strainer");
        this.addBlock((Supplier)BlocksRegistry.DARK_OAK_STRAINER, "Dark Oak Water Strainer");
        this.addBlock((Supplier)BlocksRegistry.JUNGLE_STRAINER, "Jungle Water Strainer");
        this.addBlock((Supplier)BlocksRegistry.MANGROVE_STRAINER, "Mangrove Water Strainer");
        this.addBlock((Supplier)BlocksRegistry.OAK_STRAINER, "Oak Water Strainer");
        this.addBlock((Supplier)BlocksRegistry.SPRUCE_STRAINER, "Spruce Water Strainer");
        this.addBlock((Supplier)BlocksRegistry.WARPED_STRAINER, "Warped Water Strainer");
        this.addBlock((Supplier)BlocksRegistry.TUBE, "Cast Iron Tube");
        this.addBlock((Supplier)BlocksRegistry.JAR, "Glass Jar");
        this.addBlock((Supplier)BlocksRegistry.TEMPERED_JAR, "Tempered Glass Jar");
        this.addBlock((Supplier)BlocksRegistry.JAR_AUTOMATER, "Jar Automater");
        this.addBlock((Supplier)BlocksRegistry.BLUE_MAGMA_BLOCK, "Blue Magma Block");
        this.addBlock((Supplier)BlocksRegistry.CREATIVE_HOT_TEMPERATURE_SOURCE, "Creative Hot Temperature Source");
        this.addBlock((Supplier)BlocksRegistry.CREATIVE_SUPERHEATED_TEMPERATURE_SOURCE, "Creative Superheated Temperature Source");
        this.addBlock((Supplier)BlocksRegistry.CREATIVE_CHILLED_TEMPERATURE_SOURCE, "Creative Chilled Temperature Source");
        this.addBlock((Supplier)BlocksRegistry.CAST_IRON_BLOCK, "Cast Iron Block");
        this.addBlock((Supplier)BlocksRegistry.DUST_BLOCK, "Dust");
        this.addBlock((Supplier)BlocksRegistry.CRUSHED_BASALT, "Crushed Basalt");
        this.addBlock((Supplier)BlocksRegistry.CRUSHED_ENDSTONE, "Crushed Endstone");
        this.addBlock((Supplier)BlocksRegistry.CRUSHED_NETHERRACK, "Crushed Netherrack");
        this.addItem((Supplier)ItemsRegistry.CLOTH_MESH, "Cloth Mesh");
        this.addItem((Supplier)ItemsRegistry.IRON_MESH, "Iron Mesh");
        this.addItem((Supplier)ItemsRegistry.GOLD_MESH, "Gold Mesh");
        this.addItem((Supplier)ItemsRegistry.DIAMOND_MESH, "Diamond Mesh");
        this.addItem((Supplier)ItemsRegistry.BLAZING_MESH, "Blazing Mesh");
        this.addItem((Supplier)ItemsRegistry.FLUID_CAPSULE, "Fluid Capsule");
        this.addItem((Supplier)ItemsRegistry.WATER_BOWL, "Water Bowl");
        this.addItem((Supplier)ItemsRegistry.CAST_IRON_GEAR, "Cast Iron Gear");
        this.addItem((Supplier)ItemsRegistry.CAST_IRON_INGOT, "Cast Iron Ingot");
        this.addItem((Supplier)ItemsRegistry.CAST_IRON_NUGGET, "Cast Iron Nugget");
        this.addItem((Supplier)ItemsRegistry.TEMPERED_GLASS, "Tempered Glass");
        this.addItem((Supplier)ItemsRegistry.STONE_HAMMER, "Stone Hammer");
        this.addItem((Supplier)ItemsRegistry.IRON_HAMMER, "Iron Hammer");
        this.addItem((Supplier)ItemsRegistry.GOLD_HAMMER, "Gold Hammer");
        this.addItem((Supplier)ItemsRegistry.DIAMOND_HAMMER, "Diamond Hammer");
        this.addItem((Supplier)ItemsRegistry.NETHERITE_HAMMER, "Netherite Hammer");
        this.addItem((Supplier)ItemsRegistry.CROOK, "Stone Crook");
        this.addItem((Supplier)ItemsRegistry.STONE_ROD, "Stone Rod");
        BlocksRegistry.BARRELS.forEach(barrel -> {
            Object name = barrel.getId().getPath().split("_")[0];
            name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
            this.addBlock((Supplier)barrel, (String)name + " Barrel");
        });
        this.addBlock((Supplier)BlocksRegistry.CRATE, "Crate");
        this.addBlock((Supplier)BlocksRegistry.SMALL_CRATE, "Small Crate");
        this.addBlock((Supplier)BlocksRegistry.PULSATING_CRATE, "Pulsating Crate");
        BlocksRegistry.compressedBlockTranslations().forEach((id, translation) -> {
            List<DeferredBlock<Block>> compressedBlocks = BlocksRegistry.compressedBlocks(id);
            for (int lvl = 0; lvl < compressedBlocks.size(); ++lvl) {
                DeferredBlock<Block> block = compressedBlocks.get(lvl);
                this.addBlock((Supplier)block, this.compressedBlockName((String)translation, lvl));
            }
        });
    }

    private String compressedBlockName(String name, int level) {
        String prefix = level >= COMPRESSED_PREFIXES.length ? "???" : COMPRESSED_PREFIXES[level];
        return prefix + "Compressed " + name;
    }
}

