/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.data;

import dev.ftb.mods.ftbstuffnthings.data.AdvancementsGenerator;
import dev.ftb.mods.ftbstuffnthings.data.BlockStatesGenerators;
import dev.ftb.mods.ftbstuffnthings.data.BlockTagsGenerator;
import dev.ftb.mods.ftbstuffnthings.data.DamageTypeTagsGenerator;
import dev.ftb.mods.ftbstuffnthings.data.DamageTypesGenerator;
import dev.ftb.mods.ftbstuffnthings.data.I18nGenerator;
import dev.ftb.mods.ftbstuffnthings.data.ItemModelsGenerator;
import dev.ftb.mods.ftbstuffnthings.data.ItemTagsGenerator;
import dev.ftb.mods.ftbstuffnthings.data.LootModifiersGenerator;
import dev.ftb.mods.ftbstuffnthings.data.LootTablesGenerator;
import dev.ftb.mods.ftbstuffnthings.data.RecipesGenerator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new I18nGenerator(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStatesGenerators(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelsGenerator(packOutput, existingFileHelper));
        CompletableFuture lookupProvider = event.getLookupProvider();
        BlockTagsGenerator blockTagsProvider = new BlockTagsGenerator(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagsGenerator(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipesGenerator(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTablesGenerator(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootModifiersGenerator(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementsGenerator(packOutput, lookupProvider, existingFileHelper));
        RegistrySetBuilder builder = new RegistrySetBuilder().add(Registries.DAMAGE_TYPE, DamageTypesGenerator::bootstrap);
        DatapackBuiltinEntriesProvider provider = (DatapackBuiltinEntriesProvider)generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, builder, Set.of("ftbstuff")));
        generator.addProvider(event.includeServer(), (DataProvider)new DamageTypeTagsGenerator(packOutput, provider.getRegistryProvider(), existingFileHelper));
    }
}

