/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.crafting.recipe;

import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbstuffnthings.crafting.BaseRecipe;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import dev.ftb.mods.ftbstuffnthings.util.MiscUtil;
import java.util.Map;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;

public class DripperRecipe
extends BaseRecipe<DripperRecipe> {
    private final String inputStateStr;
    private final Block inputBlock;
    private final Map<Property<?>, Comparable<?>> inputProperties;
    private final String outputString;
    private final BlockState outputState;
    private final FluidStack fluid;
    private final double chance;
    private final boolean consumeFluidOnFail;

    public DripperRecipe(String inputStateStr, String outputStateStr, FluidStack fluid, double chance, boolean consumeFluidOnFail) {
        super(RecipesRegistry.DRIP_SERIALIZER, RecipesRegistry.DRIP_TYPE);
        BlockStateParser.BlockResult blockResult;
        this.inputStateStr = inputStateStr;
        this.outputString = outputStateStr;
        this.fluid = fluid;
        this.chance = chance;
        this.consumeFluidOnFail = consumeFluidOnFail;
        try {
            blockResult = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (StringReader)new StringReader(inputStateStr), (boolean)false);
            this.inputBlock = blockResult.blockState().getBlock();
            this.inputProperties = blockResult.properties();
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
        try {
            blockResult = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (StringReader)new StringReader(outputStateStr), (boolean)false);
            this.outputState = blockResult.blockState();
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }

    public String getInputStateStr() {
        return this.inputStateStr;
    }

    public String getOutputStateStr() {
        return this.outputString;
    }

    public ItemStack getInputItem() {
        return this.inputBlock.asItem().getDefaultInstance();
    }

    public ItemStack getOutputItem() {
        return this.outputState.getBlock().asItem().getDefaultInstance();
    }

    public BlockState getOutputState() {
        return this.outputState;
    }

    public boolean consumeFluidOnFail() {
        return this.consumeFluidOnFail;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public double getChance() {
        return this.chance;
    }

    public boolean testInput(FluidStack fluidInDripper, BlockState belowState) {
        if (!FluidStack.isSameFluidSameComponents((FluidStack)fluidInDripper, (FluidStack)this.fluid) || this.inputBlock == Blocks.AIR || this.inputBlock != belowState.getBlock()) {
            return false;
        }
        for (Map.Entry<Property<?>, Comparable<?>> entry : this.inputProperties.entrySet()) {
            if (belowState.getValue(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static class Serializer<T extends DripperRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("input").forGetter(DripperRecipe::getInputStateStr), (App)Codec.STRING.fieldOf("output").forGetter(DripperRecipe::getOutputStateStr), (App)FluidStack.CODEC.fieldOf("fluid").forGetter(DripperRecipe::getFluid), (App)Codec.DOUBLE.validate(MiscUtil::validateChanceRange).optionalFieldOf("chance", (Object)1.0).forGetter(DripperRecipe::getChance), (App)Codec.BOOL.optionalFieldOf("consume_fluid_on_fail", (Object)false).forGetter(DripperRecipe::consumeFluidOnFail)).apply((Applicative)builder, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, DripperRecipe::getInputStateStr, (StreamCodec)ByteBufCodecs.STRING_UTF8, DripperRecipe::getOutputStateStr, (StreamCodec)FluidStack.STREAM_CODEC, DripperRecipe::getFluid, (StreamCodec)ByteBufCodecs.DOUBLE, DripperRecipe::getChance, (StreamCodec)ByteBufCodecs.BOOL, DripperRecipe::consumeFluidOnFail, factory::create);

        public Serializer(IFactory<T> factory) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface IFactory<T extends DripperRecipe> {
        public T create(String var1, String var2, FluidStack var3, double var4, boolean var6);
    }
}

