/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.crafting.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbstuffnthings.crafting.BaseRecipe;
import dev.ftb.mods.ftbstuffnthings.crafting.ItemWithChance;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class CrookRecipe
extends BaseRecipe<CrookRecipe> {
    private final Ingredient ingredient;
    private final List<ItemWithChance> results;
    private final int max;
    private final boolean replaceDrops;

    public CrookRecipe(Ingredient ingredient, List<ItemWithChance> results, int max, boolean replaceDrops) {
        super(RecipesRegistry.CROOK_SERIALIZER, RecipesRegistry.CROOK_TYPE);
        this.ingredient = ingredient;
        this.results = results;
        this.max = max;
        this.replaceDrops = replaceDrops;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public List<ItemWithChance> getResults() {
        return this.results;
    }

    public int getMax() {
        return this.max;
    }

    public boolean replaceDrops() {
        return this.replaceDrops;
    }

    public record CrookDrops(List<ItemWithChance> items, int max, boolean replaceDrops) {
    }

    public static class Serializer<T extends CrookRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(CrookRecipe::getIngredient), (App)ItemWithChance.CODEC.listOf().fieldOf("results").forGetter(CrookRecipe::getResults), (App)Codec.INT.optionalFieldOf("max", (Object)0).forGetter(CrookRecipe::getMax), (App)Codec.BOOL.optionalFieldOf("replace_drops", (Object)true).forGetter(CrookRecipe::replaceDrops)).apply((Applicative)builder, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, CrookRecipe::getIngredient, (StreamCodec)ItemWithChance.STREAM_CODEC.apply(ByteBufCodecs.list()), CrookRecipe::getResults, (StreamCodec)ByteBufCodecs.VAR_INT, CrookRecipe::getMax, (StreamCodec)ByteBufCodecs.BOOL, CrookRecipe::replaceDrops, factory::create);

        public Serializer(IFactory<T> factory) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface IFactory<T extends CrookRecipe> {
        public T create(Ingredient var1, List<ItemWithChance> var2, int var3, boolean var4);
    }
}

