/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.crafting;

import com.google.common.collect.ImmutableList;
import dev.ftb.mods.ftbstuffnthings.crafting.ItemWithChance;
import dev.ftb.mods.ftbstuffnthings.crafting.NoInventory;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.CrookRecipe;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.HammerRecipe;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;

@EventBusSubscriber
public class ToolsRecipeCache {
    private static final Set<Ingredient> crookableCache = new HashSet<Ingredient>();
    private static final Set<Ingredient> hammerableCache = new HashSet<Ingredient>();
    private static final Map<Item, CrookRecipe.CrookDrops> crookCache = new HashMap<Item, CrookRecipe.CrookDrops>();
    private static final Map<Item, List<ItemStack>> hammerCache = new HashMap<Item, List<ItemStack>>();

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)((ResourceManagerReloadListener)arg -> ToolsRecipeCache.refreshCaches(event.getServerResources().getRecipeManager())));
    }

    @SubscribeEvent
    public static void recipesSetup(RecipesUpdatedEvent event) {
        RecipeManager recipeManager = event.getRecipeManager();
        ToolsRecipeCache.refreshCaches(recipeManager);
    }

    public static void refreshCaches(RecipeManager manager) {
        ToolsRecipeCache.clearCache();
        crookableCache.addAll(manager.getAllRecipesFor(RecipesRegistry.CROOK_TYPE.get()).stream().map(e -> ((CrookRecipe)e.value()).getIngredient()).toList());
        hammerableCache.addAll(manager.getAllRecipesFor(RecipesRegistry.HAMMER_TYPE.get()).stream().map(e -> ((HammerRecipe)e.value()).getIngredient()).toList());
    }

    public static void clearCache() {
        crookCache.clear();
        crookableCache.clear();
        hammerCache.clear();
        hammerableCache.clear();
    }

    public static List<ItemStack> getHammerDrops(Level level, ItemStack input) {
        return hammerCache.computeIfAbsent(input.getItem(), key -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (RecipeHolder holder : level.getRecipeManager().getRecipesFor(RecipesRegistry.HAMMER_TYPE.get(), (RecipeInput)NoInventory.INSTANCE, level)) {
                HammerRecipe value = (HammerRecipe)holder.value();
                if (!value.getIngredient().test(input)) continue;
                value.getResults().forEach(e -> builder.add((Object)e.copy()));
            }
            return builder.build();
        });
    }

    public static boolean hammerable(BlockState state) {
        return ToolsRecipeCache.hammerable(new ItemStack((ItemLike)state.getBlock()));
    }

    public static boolean hammerable(ItemStack stack) {
        return hammerableCache.stream().anyMatch(e -> e.test(stack));
    }

    public static CrookRecipe.CrookDrops getCrookDrops(Level level, ItemStack input) {
        return crookCache.computeIfAbsent(input.getItem(), key -> {
            ImmutableList.Builder drops = ImmutableList.builder();
            int max = -1;
            boolean replaceDrops = false;
            for (RecipeHolder holder : level.getRecipeManager().getRecipesFor(RecipesRegistry.CROOK_TYPE.get(), (RecipeInput)NoInventory.INSTANCE, level)) {
                CrookRecipe recipe = (CrookRecipe)holder.value();
                if (!recipe.getIngredient().test(input)) continue;
                if (recipe.getMax() > 0) {
                    max = recipe.getMax();
                }
                if (recipe.replaceDrops()) {
                    replaceDrops = true;
                }
                recipe.getResults().forEach(res -> drops.add((Object)res.copy()));
            }
            return new CrookRecipe.CrookDrops((List<ItemWithChance>)drops.build(), max, replaceDrops);
        });
    }

    public static boolean crookable(BlockState state) {
        return ToolsRecipeCache.crookable(new ItemStack((ItemLike)state.getBlock()));
    }

    public static boolean crookable(ItemStack stack) {
        return crookableCache.stream().anyMatch(e -> e.test(stack));
    }
}

