/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.client.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.ftb.mods.ftbstuffnthings.blocks.jar.TemperedJarBlockEntity;
import dev.ftb.mods.ftbstuffnthings.client.RenderUtil;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TemperedJarBlockEntityRenderer
implements BlockEntityRenderer<TemperedJarBlockEntity> {
    public TemperedJarBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TemperedJarBlockEntity jar, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        int nTanks = jar.getFluidHandler().getTanks();
        int fluidAmount = 0;
        for (int i = 0; i < nTanks; ++i) {
            FluidStack stack = jar.getFluidHandler().getFluidInTank(i);
            if (stack.isEmpty()) continue;
            fluidAmount += stack.getAmount();
            FluidTank tank = new FluidTank(8000 * nTanks);
            tank.setFluid(stack);
            RenderUtil.renderFluid3d(tank, bufferSource, poseStack.last().pose(), packedLight, packedOverlay);
            double yOff = (double)stack.getAmount() / (double)tank.getCapacity();
            poseStack.translate(0.0, yOff * (double)0.69375f, 0.0);
        }
        boolean enoughFluidToFloatItems = fluidAmount > 2000;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < jar.getInputItemHandler().getSlots(); ++i) {
            ItemStack stack = jar.getInputItemHandler().getStackInSlot(i);
            if (stack.isEmpty()) continue;
            stacks.add(stack);
        }
        float circleRadius = stacks.size() == 1 ? 0.0f : 0.17f;
        float degreesPerStack = 360.0f / (float)stacks.size();
        double ticks = (float)jar.getLevel().getGameTime() + partialTick;
        float yBob = enoughFluidToFloatItems ? Mth.sin((float)((float)ticks / 10.0f % 360.0f)) * 0.01f : 0.0f;
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        poseStack.translate(0.5, 0.1, 0.5);
        for (int i = 0; i < stacks.size(); ++i) {
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees((float)i * degreesPerStack + (enoughFluidToFloatItems ? (float)ticks / 3.0f % 360.0f : 0.0f)));
            poseStack.translate(circleRadius, yBob, 0.0f);
            poseStack.scale(0.25f, 0.25f, 0.25f);
            BakedModel bakedModel = itemRenderer.getModel((ItemStack)stacks.get(i), jar.getLevel(), null, 0);
            itemRenderer.render((ItemStack)stacks.get(i), ItemDisplayContext.FIXED, true, poseStack, bufferSource, packedLight, packedOverlay, bakedModel);
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

