/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import dev.ftb.mods.ftbstuffnthings.FTBStuffNThings;
import dev.ftb.mods.ftbstuffnthings.blocks.tube.TubeBlockEntity;
import dev.ftb.mods.ftbstuffnthings.util.DirectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class TubeModel
extends BakedModelWrapper<BakedModel> {
    private static final Map<Integer, List<BakedQuad>> MODEL_CACHE = new ConcurrentHashMap<Integer, List<BakedQuad>>();
    private final BakedModel[] rotated;

    public TubeModel(BakedModel centre, BakedModel[] rotated) {
        super(centre);
        this.rotated = rotated;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(super.getQuads(state, side, rand, extraData, renderType));
        Integer connected = (Integer)extraData.get(TubeBlockEntity.CONNECTION_PROPERTY);
        if (side == null && connected != null) {
            List<BakedQuad> cachedQuads = MODEL_CACHE.get(connected);
            if (cachedQuads == null) {
                cachedQuads = new ArrayList<BakedQuad>();
                for (Direction dir : DirectionUtil.VALUES) {
                    if (!DirectionUtil.getDirectionBit(connected, dir)) continue;
                    cachedQuads.addAll(this.rotated[dir.get3DDataValue()].getQuads(state, null, rand, extraData, renderType));
                }
                MODEL_CACHE.put(connected, cachedQuads);
            }
            quads.addAll(cachedQuads);
        }
        return quads;
    }

    public static enum Loader implements IGeometryLoader<Geometry>
    {
        INSTANCE;

        public static final ResourceLocation ID;

        public Geometry read(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            BlockModel centre = Loader.loadModel(FTBStuffNThings.id("block/tube_center"));
            BlockModel tubePart = Loader.loadModel(FTBStuffNThings.id("block/tube_base"));
            return new Geometry(centre, tubePart);
        }

        private static BlockModel loadModel(ResourceLocation location) {
            BlockModel blockModel;
            block8: {
                ResourceManager manager = Minecraft.getInstance().getResourceManager();
                ResourceLocation file = ModelBakery.MODEL_LISTER.idToFile(location);
                InputStream stream = manager.getResourceOrThrow(file).open();
                try {
                    blockModel = BlockModel.fromStream((Reader)new InputStreamReader(stream));
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new JsonParseException("Failed to load part model '" + String.valueOf(file) + "'", (Throwable)e);
                    }
                }
                stream.close();
            }
            return blockModel;
        }

        static {
            ID = FTBStuffNThings.id("tube");
        }
    }

    public record Geometry(BlockModel centre, BlockModel tubePart) implements IUnbakedGeometry<Geometry>
    {
        private static final Vector3f BLOCK_CENTER = new Vector3f(0.5f, 0.5f, 0.5f);
        private static final BlockModelRotation[] ROTATIONS = new BlockModelRotation[]{BlockModelRotation.X0_Y0, BlockModelRotation.X180_Y0, BlockModelRotation.X270_Y0, BlockModelRotation.X270_Y180, BlockModelRotation.X270_Y270, BlockModelRotation.X270_Y90};

        public BakedModel bake(IGeometryBakingContext iGeometryBakingContext, ModelBaker modelBaker, Function<Material, TextureAtlasSprite> function, ModelState modelState, ItemOverrides itemOverrides) {
            BakedModel[] rotated = new BakedModel[6];
            for (Direction dir : DirectionUtil.VALUES) {
                int d = dir.get3DDataValue();
                ModelState rotatedState = UnbakedGeometryHelper.composeRootTransformIntoModelState((ModelState)modelState, (Transformation)ROTATIONS[d].getRotation().applyOrigin(BLOCK_CENTER));
                rotated[d] = this.tubePart.bake(modelBaker, this.tubePart, function, rotatedState, true);
            }
            return new TubeModel(this.centre.bake(modelBaker, this.centre, function, modelState, true), rotated);
        }
    }
}

