/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.client;

import dev.ftb.mods.ftblibrary.util.neoforge.FluidKey;
import dev.ftb.mods.ftbstuffnthings.client.GuiUtil;
import dev.ftb.mods.ftbstuffnthings.items.FluidCapsuleItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidCapsuleColorHandler {
    private static final Map<FluidKey, Integer> COLOR_MAP = new HashMap<FluidKey, Integer>();

    public static int getColor(ItemStack capsuleStack) {
        FluidStack fStack = FluidCapsuleItem.getFluid(capsuleStack);
        return COLOR_MAP.computeIfAbsent(new FluidKey(fStack), k -> FluidCapsuleColorHandler.calculateFluidColor(fStack));
    }

    private static int calculateFluidColor(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return -16777216;
        }
        IClientFluidTypeExtensions renderProps = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation fluidStill = Objects.requireNonNullElse(renderProps.getStillTexture(fluidStack), MissingTextureAtlasSprite.getLocation());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidStill);
        float[] tint = GuiUtil.decomposeColorF(renderProps.getTintColor(fluidStack));
        float[] rgba = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        for (int y = 0; y < sprite.contents().height(); ++y) {
            for (int x = 0; x < sprite.contents().width(); ++x) {
                int color = sprite.getPixelRGBA(0, x, y);
                float a = color >> 24 & 0xFF;
                if (!(a > 0.0f)) continue;
                rgba[0] = rgba[0] + (float)(color >> 0 & 0xFF) * tint[1];
                rgba[1] = rgba[1] + (float)(color >> 8 & 0xFF) * tint[2];
                rgba[2] = rgba[2] + (float)(color >> 16 & 0xFF) * tint[3];
                rgba[3] = rgba[3] + a;
            }
        }
        int nPixels = sprite.contents().width() * sprite.contents().height();
        rgba[0] = rgba[0] / (float)nPixels;
        rgba[1] = rgba[1] / (float)nPixels;
        rgba[2] = rgba[2] / (float)nPixels;
        rgba[3] = rgba[3] / (float)nPixels;
        return (int)rgba[3] << 24 | (int)rgba[0] << 16 | (int)rgba[1] << 8 | (int)rgba[2];
    }
}

