/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.tube;

import dev.ftb.mods.ftbstuffnthings.blocks.tube.TubeBlockEntity;
import dev.ftb.mods.ftbstuffnthings.util.DirectionUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TubeBlock
extends Block
implements EntityBlock {
    public static final VoxelShape CENTER_SHAPE = TubeBlock.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    public static final VoxelShape[] ARM_SHAPE = new VoxelShape[]{TubeBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), TubeBlock.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), TubeBlock.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0), TubeBlock.box((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0), TubeBlock.box((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0), TubeBlock.box((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0)};
    private static final Map<Integer, VoxelShape> SHAPE_CACHE = new ConcurrentHashMap<Integer, VoxelShape>();

    public TubeBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(0.7f).sound(SoundType.NETHERITE_BLOCK));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TubeBlockEntity(blockPos, blockState);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return state;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TubeBlockEntity) {
            TubeBlockEntity tube = (TubeBlockEntity)blockEntity;
            return this.getCachedShape(tube);
        }
        return CENTER_SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TubeBlockEntity) {
            TubeBlockEntity tube = (TubeBlockEntity)blockEntity;
            tube.updateConnectedSides();
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TubeBlockEntity) {
            TubeBlockEntity tube = (TubeBlockEntity)blockEntity;
            Direction relDir = DirectionUtil.getRelativeDirection(pos, neighborPos);
            if (relDir != null) {
                tube.updateSide(relDir, true);
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide && player.isShiftKeyDown() && player.getMainHandItem().isEmpty()) {
            int x = TubeBlock.coord(hitResult.getLocation().x - (double)pos.getX());
            int y = TubeBlock.coord(hitResult.getLocation().y - (double)pos.getY());
            int z = TubeBlock.coord(hitResult.getLocation().z - (double)pos.getZ());
            Direction dir = TubeBlock.getDirForHitLocation(x, y, z, hitResult.getDirection());
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof TubeBlockEntity) {
                TubeBlockEntity tube = (TubeBlockEntity)blockEntity;
                if (tube.isSideClosed(dir)) {
                    BlockPos pos1 = pos.relative(dir);
                    BlockState state1 = level.getBlockState(pos1);
                    if (state1.getBlock() == this) {
                        tube.setSideClosed(dir, false);
                    }
                } else if (tube.isSideConnected(dir)) {
                    tube.setSideClosed(dir, true);
                } else {
                    TubeBlockEntity neighbourTube;
                    BlockEntity blockEntity2 = level.getBlockEntity(pos.relative(dir));
                    if (blockEntity2 instanceof TubeBlockEntity && (neighbourTube = (TubeBlockEntity)blockEntity2).isSideClosed(dir.getOpposite())) {
                        neighbourTube.setSideClosed(dir.getOpposite(), false);
                        neighbourTube.updateSide(dir.getOpposite(), true);
                    }
                }
                tube.updateConnectedSides();
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    private static int coord(double v) {
        return v < 0.375 ? -1 : (v > 0.625 ? 1 : 0);
    }

    private static Direction getDirForHitLocation(int x, int y, int z, Direction dir) {
        return Arrays.stream(DirectionUtil.VALUES).filter(d -> d.getStepX() == x && d.getStepY() == y && d.getStepZ() == z).findFirst().orElse(dir);
    }

    private VoxelShape getCachedShape(TubeBlockEntity tube) {
        int data = tube.getShapeCacheKey();
        VoxelShape cachedShape = SHAPE_CACHE.get(data);
        if (cachedShape == null) {
            cachedShape = CENTER_SHAPE;
            for (Direction dir : Direction.values()) {
                if (!tube.isSideClosed(dir) && !tube.isSideConnected(dir)) continue;
                cachedShape = Shapes.joinUnoptimized((VoxelShape)cachedShape, (VoxelShape)ARM_SHAPE[dir.get3DDataValue()], (BooleanOp)BooleanOp.OR);
            }
            cachedShape = cachedShape.optimize();
            SHAPE_CACHE.put(data, cachedShape);
        }
        return cachedShape;
    }
}

