/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.strainer;

import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.strainer.WaterStrainerBlockEntity;
import dev.ftb.mods.ftbstuffnthings.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WaterStrainerBlock
extends AbstractMachineBlock {
    private static final VoxelShape SHAPE0 = VoxelShapeUtils.or(WaterStrainerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), WaterStrainerBlock.box((double)0.5, (double)2.0, (double)0.5, (double)15.5, (double)14.0, (double)15.5), WaterStrainerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0), WaterStrainerBlock.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), WaterStrainerBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), WaterStrainerBlock.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0));
    private static final VoxelShape SHAPE1 = WaterStrainerBlock.box((double)1.5, (double)2.0, (double)1.5, (double)14.5, (double)14.0, (double)14.5);
    private static final VoxelShape SHAPE = Shapes.join((VoxelShape)SHAPE0, (VoxelShape)SHAPE1, (BooleanOp)BooleanOp.ONLY_FIRST);
    private final WoodType type;

    public WaterStrainerBlock(BlockBehaviour.Properties props, WoodType type) {
        super(props);
        this.type = type;
    }

    @Override
    protected boolean hasActiveStateProperty() {
        return false;
    }

    public static BlockBehaviour.Properties defaultProps() {
        return BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.6f).noOcclusion();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    @Deprecated
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext arg) {
        FluidState fluidState = arg.getLevel().getFluidState(arg.getClickedPos());
        return (BlockState)super.getStateForPlacement(arg).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, pos, facingPos);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public WoodType getWoodType() {
        return this.type;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WaterStrainerBlockEntity(pos, state);
    }
}

