/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.sluice;

import dev.ftb.mods.ftbstuffnthings.blocks.sluice.SluiceBlockEntity;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.BlockState;

public enum SluiceType implements StringRepresentable
{
    OAK("oak", 1.0, 1.0, 12000, false, false, false, 0, SluiceBlockEntity.Oak::new),
    IRON("iron", 0.8, 0.6, 12000, true, false, false, 0, SluiceBlockEntity.Iron::new),
    DIAMOND("diamond", 0.6, 0.75, 12000, true, true, false, 0, SluiceBlockEntity.Diamond::new),
    NETHERITE("netherite", 0.4, 0.5, 12000, true, true, true, 40, SluiceBlockEntity.Netherite::new);

    private final String name;
    public final double defTimeMod;
    public final double defFluidMod;
    public final int defCapacity;
    public final boolean defItemIO;
    public final boolean defFluidIO;
    public final boolean defUpgradeable;
    public final int defEnergyUsage;
    private final BiFunction<BlockPos, BlockState, ? extends SluiceBlockEntity> beFactory;

    private SluiceType(String name, double defTimeMod, double defFluidMod, int defCapacity, boolean defItemIO, boolean defFluidIO, boolean defUpgradeable, int defEnergyUsage, BiFunction<BlockPos, BlockState, ? extends SluiceBlockEntity> beFactory) {
        this.name = name;
        this.defTimeMod = defTimeMod;
        this.defFluidMod = defFluidMod;
        this.defCapacity = defCapacity;
        this.defItemIO = defItemIO;
        this.defFluidIO = defFluidIO;
        this.defUpgradeable = defUpgradeable;
        this.defEnergyUsage = defEnergyUsage;
        this.beFactory = beFactory;
    }

    public String getSerializedName() {
        return this.name;
    }

    public SluiceBlockEntity createBlockEntity(BlockPos pos, BlockState state) {
        return this.beFactory.apply(pos, state);
    }
}

