/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.pump;

import dev.ftb.mods.ftbstuffnthings.Config;
import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineBlockEntity;
import dev.ftb.mods.ftbstuffnthings.blocks.pump.PumpBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.sluice.SluiceBlockEntity;
import dev.ftb.mods.ftbstuffnthings.registry.BlockEntitiesRegistry;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class PumpBlockEntity
extends AbstractMachineBlockEntity {
    private static final int TICK_RATE = 20;
    private static final List<Direction> OUTPUT_DIRS = List.of(Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);
    private int timeLeft = 0;
    private int tickCounter = 0;
    public boolean creative = false;
    public Fluid creativeFluid = Fluids.WATER;
    public Item creativeItem = null;
    private final Map<Direction, BlockCapabilityCache<IFluidHandler, Direction>> capabilityCacheMap = new EnumMap<Direction, BlockCapabilityCache<IFluidHandler, Direction>>(Direction.class);

    public PumpBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntitiesRegistry.PUMP.get(), pos, state);
    }

    @Override
    public void tickServer(ServerLevel serverLevel) {
        if (this.timeLeft <= 0 && !this.creative) {
            return;
        }
        FluidState fluidState = serverLevel.getBlockState(this.getBlockPos().below()).getFluidState();
        if (!this.creative && fluidState.isEmpty() || !fluidState.isSource() || !fluidState.is(FluidTags.WATER)) {
            return;
        }
        if (++this.tickCounter >= 20) {
            this.runOneCycle(serverLevel);
        }
    }

    @Override
    protected Optional<ParticleOptions> getActiveParticle() {
        return Optional.of(ParticleTypes.SPLASH);
    }

    private void runOneCycle(ServerLevel serverLevel) {
        this.tickCounter = 0;
        int totalFilled = 0;
        for (Direction dir : OUTPUT_DIRS) {
            BlockCapabilityCache fluidCache = this.capabilityCacheMap.computeIfAbsent(dir, k -> BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)this.getBlockPos().relative(dir), (Object)dir.getOpposite()));
            IFluidHandler handler = (IFluidHandler)fluidCache.getCapability();
            if (handler == null) continue;
            totalFilled += handler.fill(new FluidStack((Fluid)Fluids.WATER, ((Integer)Config.PUMP_FLUID_TRANSFER.get()).intValue()), IFluidHandler.FluidAction.EXECUTE);
            this.handleCreateItemInsertion(handler);
        }
        if (totalFilled > 0) {
            if (!this.creative) {
                this.timeLeft = Math.max(0, this.timeLeft - totalFilled / 50);
            }
            this.updatePumpProgress();
            if (this.timeLeft == 0) {
                this.level.setBlock(this.getBlockPos(), (BlockState)((BlockState)this.getBlockState().setValue((Property)AbstractMachineBlock.ACTIVE, (Comparable)Boolean.valueOf(false))).setValue(PumpBlock.PROGRESS, (Comparable)((Object)PumpBlock.Progress.ZERO)), 3);
            }
        }
    }

    private void handleCreateItemInsertion(IFluidHandler handler) {
        SluiceBlockEntity.SluiceFluidTank sluiceFluidTank;
        ItemStackHandler itemHandler;
        if (this.creative && this.creativeItem != null && handler instanceof SluiceBlockEntity.SluiceFluidTank && (itemHandler = (sluiceFluidTank = (SluiceBlockEntity.SluiceFluidTank)handler).getOwner().getItemHandler(null)) != null) {
            itemHandler.insertItem(0, this.creativeItem.getDefaultInstance(), false);
        }
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        ResourceLocation key;
        compound.putInt("time_left", this.timeLeft);
        compound.putBoolean("is_creative", this.creative);
        if (this.creativeFluid != Fluids.WATER) {
            key = BuiltInRegistries.FLUID.getKey((Object)this.creativeFluid);
            compound.putString("creative_fluid", key.toString());
        }
        if (this.creativeItem != null) {
            key = BuiltInRegistries.ITEM.getKey((Object)this.creativeItem);
            compound.putString("creative_item", key.toString());
        }
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        ResourceLocation creativeItemFromReg;
        ResourceLocation creativeFluidFromReg;
        this.timeLeft = compound.getInt("time_left");
        this.creative = compound.getBoolean("is_creative");
        if (compound.contains("creative_fluid") && (creativeFluidFromReg = ResourceLocation.tryParse((String)compound.getString("creative_fluid"))) != null) {
            this.creativeFluid = (Fluid)BuiltInRegistries.FLUID.get(creativeFluidFromReg);
        }
        if (compound.contains("creative_item") && (creativeItemFromReg = ResourceLocation.tryParse((String)compound.getString("creative_item"))) != null) {
            this.creativeItem = (Item)BuiltInRegistries.ITEM.get(creativeItemFromReg);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag data = new CompoundTag();
        this.saveAdditional(data, registries);
        return data;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(pkt.getTag(), lookupProvider);
    }

    @Override
    @Nullable
    public IItemHandler getItemHandler(@Nullable Direction side) {
        return null;
    }

    @Override
    @Nullable
    public IFluidHandler getFluidHandler(@Nullable Direction side) {
        return null;
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyHandler(@Nullable Direction side) {
        return null;
    }

    public int getTimeLeft() {
        return this.timeLeft;
    }

    public boolean windUp() {
        int maxCharge = (Integer)Config.PUMP_MAX_CHARGE.get();
        if (this.timeLeft >= maxCharge) {
            return false;
        }
        this.timeLeft = Math.min(maxCharge, this.timeLeft + (Integer)Config.PUMP_CHARGEUP_AMOUNT.get());
        this.updatePumpProgress();
        this.setChanged();
        return true;
    }

    private void updatePumpProgress() {
        if (!((Boolean)this.getBlockState().getValue((Property)AbstractMachineBlock.ACTIVE)).booleanValue() && this.timeLeft > 0) {
            this.setPumpProgress(PumpBlock.Progress.ZERO);
        } else {
            PumpBlock.Progress value = (PumpBlock.Progress)((Object)this.getBlockState().getValue(PumpBlock.PROGRESS));
            if (this.timeLeft < 1200 && value != PumpBlock.Progress.TWENTY) {
                this.setPumpProgress(PumpBlock.Progress.TWENTY);
            } else if (this.timeLeft >= 1200 && this.timeLeft < 2400 && value != PumpBlock.Progress.FORTY) {
                this.setPumpProgress(PumpBlock.Progress.FORTY);
            } else if (this.timeLeft >= 2400 && this.timeLeft < 3600 && value != PumpBlock.Progress.SIXTY) {
                this.setPumpProgress(PumpBlock.Progress.SIXTY);
            } else if (this.timeLeft >= 3600 && this.timeLeft < 4800 && value != PumpBlock.Progress.EIGHTY) {
                this.setPumpProgress(PumpBlock.Progress.EIGHTY);
            } else if (this.timeLeft >= 4800 && this.timeLeft < 5500 && value != PumpBlock.Progress.HUNDRED) {
                this.setPumpProgress(PumpBlock.Progress.HUNDRED);
            }
        }
    }

    private void setPumpProgress(PumpBlock.Progress progress) {
        this.level.setBlock(this.getBlockPos(), (BlockState)((BlockState)this.getBlockState().setValue((Property)AbstractMachineBlock.ACTIVE, (Comparable)Boolean.valueOf(true))).setValue(PumpBlock.PROGRESS, (Comparable)((Object)progress)), 3);
    }
}

