/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.pump;

import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.pump.PumpBlockEntity;
import dev.ftb.mods.ftbstuffnthings.registry.CriterionTriggerRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ModDamageSources;
import dev.ftb.mods.ftbstuffnthings.util.VoxelShapeUtils;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class PumpBlock
extends AbstractMachineBlock
implements EntityBlock {
    public static final int PUMP_DAMAGE_AMOUNT = 2;
    private static final VoxelShape NORTH = VoxelShapeUtils.or(PumpBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), PumpBlock.box((double)3.0, (double)10.0, (double)6.0, (double)13.0, (double)13.0, (double)9.0), PumpBlock.box((double)6.0, (double)10.0, (double)0.0, (double)10.0, (double)12.0, (double)2.0), PumpBlock.box((double)0.0, (double)15.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), PumpBlock.box((double)1.0, (double)10.0, (double)9.0, (double)15.0, (double)15.0, (double)15.0), PumpBlock.box((double)0.0, (double)10.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), PumpBlock.box((double)0.0, (double)10.0, (double)8.0, (double)1.0, (double)15.0, (double)9.0), PumpBlock.box((double)15.0, (double)10.0, (double)8.0, (double)16.0, (double)15.0, (double)9.0), PumpBlock.box((double)15.0, (double)10.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), PumpBlock.box((double)2.5, (double)4.0, (double)3.0, (double)13.5, (double)15.0, (double)5.0), PumpBlock.box((double)7.0, (double)9.0, (double)2.0, (double)9.0, (double)11.0, (double)6.0));
    private static final VoxelShape EAST = VoxelShapeUtils.rotateY(NORTH, 90);
    private static final VoxelShape SOUTH = VoxelShapeUtils.rotateY(EAST, 90);
    private static final VoxelShape WEST = VoxelShapeUtils.rotateY(SOUTH, 90);
    private static final Map<Direction, VoxelShape> SHAPES = new EnumMap<Direction, VoxelShape>(Map.of(Direction.NORTH, NORTH, Direction.EAST, EAST, Direction.SOUTH, SOUTH, Direction.WEST, WEST));
    public static final EnumProperty<Progress> PROGRESS = EnumProperty.create((String)"progress", Progress.class);

    public PumpBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(1.0f, 1.0f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(PROGRESS, (Comparable)((Object)Progress.ZERO))).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PROGRESS});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player instanceof FakePlayer) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof PumpBlockEntity)) {
            return InteractionResult.PASS;
        }
        PumpBlockEntity pump = (PumpBlockEntity)blockEntity;
        if (!level.isClientSide && !pump.windUp()) {
            player.hurt(level.damageSources().source(ModDamageSources.STATIC_ELECTRIC, (Entity)player), 2.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                CriterionTriggerRegistry.SUPERCHARGED.get().trigger(sp);
            }
            if (player.getHealth() - 2.0f < 0.0f) {
                LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
                if (lightning != null) {
                    lightning.moveTo(Vec3.atBottomCenterOf((Vec3i)player.blockPosition()));
                    lightning.setVisualOnly(true);
                    level.addFreshEntity((Entity)lightning);
                }
            } else if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 vec = Vec3.atCenterOf((Vec3i)pos.above());
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, vec.x, vec.y, vec.z, 15, 0.2, 0.2, 0.2, 0.5);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof PumpBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        PumpBlockEntity pump = (PumpBlockEntity)blockEntity;
        if (pump.creative) {
            ItemStack itemInHand = player.getItemInHand(hand);
            ItemInteractionResult result = ItemInteractionResult.FAIL;
            if (!itemInHand.isEmpty()) {
                Item item = itemInHand.getItem();
                if (item instanceof BucketItem) {
                    BucketItem bucketItem = (BucketItem)item;
                    pump.creativeFluid = bucketItem.content;
                    this.sendTileUpdate(level, pos, state, pump);
                    result = ItemInteractionResult.SUCCESS;
                } else {
                    IFluidHandlerItem capability = (IFluidHandlerItem)itemInHand.getCapability(Capabilities.FluidHandler.ITEM);
                    if (capability != null) {
                        pump.creativeFluid = capability.getFluidInTank(0).getFluid();
                        this.sendTileUpdate(level, pos, state, pump);
                        result = ItemInteractionResult.SUCCESS;
                    }
                }
            }
            if (result.consumesAction()) {
                return result;
            }
            pump.creativeItem = itemInHand.getItem();
            if (!level.isClientSide) {
                this.sendTileUpdate(level, pos, state, pump);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private void sendTileUpdate(Level level, BlockPos pos, BlockState state, PumpBlockEntity tile) {
        tile.setChanged();
        level.sendBlockUpdated(pos, state, state, 3);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new PumpBlockEntity(blockPos, blockState);
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return SHAPES.getOrDefault(dir, NORTH);
    }

    public static enum Progress implements StringRepresentable
    {
        ZERO(0),
        TWENTY(20),
        FORTY(40),
        SIXTY(60),
        EIGHTY(80),
        HUNDRED(100);

        private final int percentage;

        private Progress(int percentage) {
            this.percentage = percentage;
        }

        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

