/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.hammer;

import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.hammer.AutoHammerProperties;
import dev.ftb.mods.ftbstuffnthings.crafting.ToolsRecipeCache;
import dev.ftb.mods.ftbstuffnthings.registry.BlockEntitiesRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.ForwardingItemHandler;
import org.jetbrains.annotations.Nullable;

public class AutoHammerBlockEntity
extends BlockEntity {
    private final AutoHammerProperties props;
    private final AutoHammerItemHandler itemHandler = new AutoHammerItemHandler();
    private final InputHandler inputHandler = new InputHandler((IItemHandler)this.itemHandler);
    private boolean active;
    private int progress;
    private int displayProgress;
    private ItemStack processingStack = ItemStack.EMPTY;
    private int timeout = 0;
    private int maxTimeout;
    private final List<ItemStack> overflow = new ArrayList<ItemStack>();
    private final OutputHandler outputHandler = new OutputHandler(this.overflow);
    private BlockCapabilityCache<IItemHandler, Direction> inputCache;
    private BlockCapabilityCache<IItemHandler, Direction> outputCache;

    protected AutoHammerBlockEntity(BlockEntityType<?> type, AutoHammerProperties props, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.props = props;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event, BlockEntityType<? extends AutoHammerBlockEntity> machine) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, machine, AutoHammerBlockEntity::getItemHandler);
    }

    private IItemHandler getItemHandler(Direction side) {
        Direction dir = AutoHammerBlockEntity.getInputDirection((Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
        if (side == dir) {
            return this.inputHandler;
        }
        if (side == dir.getOpposite()) {
            return this.outputHandler;
        }
        return null;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.put("ProcessingStack", this.processingStack.saveOptional(registries));
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.processingStack = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)tag.getCompound("ProcessingStack"));
        this.displayProgress = 0;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.handleUpdateTag(pkt.getTag(), lookupProvider);
    }

    public void tickClient() {
        if (!this.processingStack.isEmpty() && this.level != null && ((Boolean)this.getBlockState().getValue((Property)AbstractMachineBlock.ACTIVE)).booleanValue() && ++this.displayProgress >= this.props.getHammerSpeed()) {
            this.displayProgress = 0;
            Item item = this.processingStack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                this.level.addDestroyBlockEffect(this.getBlockPos(), blockItem.getBlock().defaultBlockState());
            }
        }
    }

    public void tickServer() {
        boolean stateActive;
        if (!((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            return;
        }
        ItemStack inputStack = this.itemHandler.getStackInSlot(0);
        ItemStack prevProcessingStack = this.processingStack.copy();
        if (this.timeout > 0) {
            --this.timeout;
            if (this.timeout == 0) {
                this.maxTimeout = 0;
            }
        } else if (!this.overflow.isEmpty()) {
            ArrayList<ItemStack> retry = new ArrayList<ItemStack>(this.overflow);
            this.overflow.clear();
            if (!this.tryPushToOutput(retry)) {
                this.goOnTimeout(30);
            }
            this.setChanged();
        } else if (this.progress == 0) {
            this.processingStack = ItemStack.EMPTY;
            if (inputStack.isEmpty()) {
                if (!this.tryPullFromInput()) {
                    this.goOnTimeout(20);
                } else {
                    inputStack = this.itemHandler.getStackInSlot(0);
                }
            }
            if (!inputStack.isEmpty()) {
                hammerDrops = ToolsRecipeCache.getHammerDrops(this.level, inputStack);
                if (!hammerDrops.isEmpty()) {
                    this.processingStack = this.itemHandler.extractItem(0, 1, false);
                    this.progress = 1;
                    this.active = true;
                    this.setChanged();
                } else {
                    Block.popResource((Level)this.getLevel(), (BlockPos)this.getBlockPos().above(), (ItemStack)inputStack);
                    this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
                    this.goOnTimeout(20);
                }
            }
        } else if (this.progress <= this.props.getHammerSpeed()) {
            ++this.progress;
            this.setChanged();
        } else {
            hammerDrops = ToolsRecipeCache.getHammerDrops(this.level, this.processingStack);
            this.progress = 0;
            if (this.tryPushToOutput(hammerDrops)) {
                this.setChanged();
            } else {
                this.goOnTimeout(30);
            }
            this.processingStack = ItemStack.EMPTY;
        }
        if ((stateActive = ((Boolean)this.getBlockState().getValue((Property)AbstractMachineBlock.ACTIVE)).booleanValue()) && !this.active) {
            this.getLevel().setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)AbstractMachineBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
        } else if (!stateActive && this.active) {
            this.getLevel().setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)AbstractMachineBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)prevProcessingStack, (ItemStack)this.processingStack)) {
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    private boolean tryPullFromInput() {
        IItemHandler src;
        if (this.inputCache == null) {
            Direction dir = AutoHammerBlockEntity.getInputDirection((Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
            this.inputCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)this.getLevel()), (BlockPos)this.getBlockPos().relative(dir), (Object)dir.getOpposite());
        }
        if ((src = (IItemHandler)this.inputCache.getCapability()) != null && !(src instanceof OutputHandler)) {
            for (int i = 0; i < src.getSlots(); ++i) {
                ItemStack in;
                ItemStack stack = src.getStackInSlot(i);
                if (!ToolsRecipeCache.hammerable(stack) || (in = src.extractItem(i, 1, true)).isEmpty() || !this.itemHandler.insertItem(0, in, false).isEmpty()) continue;
                src.extractItem(i, 1, false);
                return true;
            }
        }
        return false;
    }

    public static Direction getInputDirection(Direction facing) {
        return facing.getCounterClockWise();
    }

    private boolean tryPushToOutput(List<ItemStack> outputs) {
        IItemHandler dest;
        if (this.outputCache == null) {
            Direction dir = AutoHammerBlockEntity.getOutputDirection((Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
            this.outputCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)this.getLevel()), (BlockPos)this.getBlockPos().relative(dir), (Object)dir.getOpposite());
        }
        if ((dest = (IItemHandler)this.outputCache.getCapability()) != null) {
            for (ItemStack stack : outputs) {
                ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)dest, (ItemStack)stack.copy(), (boolean)false);
                if (excess.isEmpty()) continue;
                this.overflow.addLast(excess);
            }
        } else {
            for (ItemStack output : outputs) {
                this.overflow.addLast(output.copy());
            }
        }
        return this.overflow.isEmpty();
    }

    public static Direction getOutputDirection(Direction facing) {
        return facing.getClockWise();
    }

    private void goOnTimeout(int timeout) {
        this.timeout = this.maxTimeout = timeout;
        this.active = false;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("Input"));
        this.active = tag.getBoolean("Active");
        this.progress = tag.getInt("Progress");
        this.processingStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("ProcessingStack"));
        if (tag.contains("Overflow")) {
            this.overflow.clear();
            ItemStackHandler o = new ItemStackHandler();
            o.deserializeNBT(registries, tag.getCompound("Overflow"));
            for (int i = 0; i < o.getSlots(); ++i) {
                this.overflow.addLast(o.getStackInSlot(i));
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("Input", (Tag)this.itemHandler.serializeNBT(registries));
        if (this.active) {
            tag.putBoolean("Active", true);
        }
        if (this.progress != 0) {
            tag.putInt("Progress", this.progress);
        }
        if (!this.processingStack.isEmpty()) {
            tag.put("ProcessingStack", this.processingStack.save(registries));
        }
        if (!this.overflow.isEmpty()) {
            ItemStackHandler o = new ItemStackHandler(this.overflow.size());
            for (int i = 0; i < this.overflow.size(); ++i) {
                o.setStackInSlot(i, this.overflow.get(i));
            }
            tag.put("Overflow", (Tag)o.serializeNBT(registries));
        }
    }

    public void dropInventoryOnBreak() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!stack.isEmpty()) {
            Block.popResource((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (ItemStack)stack);
        }
        if (!this.processingStack.isEmpty()) {
            Block.popResource((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (ItemStack)this.processingStack);
        }
        this.overflow.forEach(os -> Block.popResource((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (ItemStack)os));
    }

    public ItemStack getProcessingStack() {
        return this.processingStack;
    }

    public int getDestroyStage() {
        return (int)((float)this.displayProgress / (float)this.props.getHammerSpeed() * 10.0f);
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.props.getHammerSpeed();
    }

    public Collection<ItemStack> getOverflow() {
        return this.overflow;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getMaxTimeout() {
        return this.maxTimeout;
    }

    public void clearCapabilityCaches() {
        this.outputCache = null;
        this.inputCache = null;
    }

    private class AutoHammerItemHandler
    extends ItemStackHandler {
        public AutoHammerItemHandler() {
            super(1);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return ToolsRecipeCache.hammerable(stack);
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            AutoHammerBlockEntity.this.setChanged();
        }
    }

    private static class InputHandler
    extends ForwardingItemHandler {
        public InputHandler(IItemHandler delegate) {
            super(delegate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }
    }

    private record OutputHandler(List<ItemStack> overflow) implements IItemHandler
    {
        public int getSlots() {
            return this.overflow.size();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.overflow.get(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.overflow.isEmpty() ? ItemStack.EMPTY : (simulate ? this.overflow.getFirst() : this.overflow.removeFirst());
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return true;
        }
    }

    public static class Netherite
    extends AutoHammerBlockEntity {
        public Netherite(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.NETHERITE_HAMMER.get(), AutoHammerProperties.NETHERITE, pos, blockState);
        }
    }

    public static class Diamond
    extends AutoHammerBlockEntity {
        public Diamond(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.DIAMOND_HAMMER.get(), AutoHammerProperties.DIAMOND, pos, blockState);
        }
    }

    public static class Gold
    extends AutoHammerBlockEntity {
        public Gold(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.GOLD_HAMMER.get(), AutoHammerProperties.GOLD, pos, blockState);
        }
    }

    public static class Iron
    extends AutoHammerBlockEntity {
        public Iron(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.IRON_HAMMER.get(), AutoHammerProperties.IRON, pos, blockState);
        }
    }
}

