/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.hammer;

import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.hammer.AutoHammerBlockEntity;
import dev.ftb.mods.ftbstuffnthings.blocks.hammer.AutoHammerProperties;
import dev.ftb.mods.ftbstuffnthings.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AutoHammerBlock
extends Block
implements EntityBlock {
    private static final VoxelShape EAST_WEST = VoxelShapeUtils.or(AutoHammerBlock.box((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), AutoHammerBlock.box((double)0.0, (double)4.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0), AutoHammerBlock.box((double)0.0, (double)4.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0), AutoHammerBlock.box((double)14.0, (double)4.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0), AutoHammerBlock.box((double)14.0, (double)4.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0), AutoHammerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), AutoHammerBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), AutoHammerBlock.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)2.0), AutoHammerBlock.box((double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0, (double)16.0));
    public static final VoxelShape NORTH_SOUTH = VoxelShapeUtils.rotateY(EAST_WEST, 90);
    private final AutoHammerProperties props;

    public AutoHammerBlock(AutoHammerProperties props) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(1.0f, 1.0f));
        this.props = props;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)AbstractMachineBlock.ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, AbstractMachineBlock.ACTIVE, BlockStateProperties.ENABLED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public VoxelShape getVisualShape(BlockState arg, BlockGetter arg2, BlockPos arg3, CollisionContext arg4) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            return NORTH_SOUTH;
        }
        return EAST_WEST;
    }

    @Deprecated
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof AutoHammerBlockEntity) {
                AutoHammerBlockEntity autoHammer = (AutoHammerBlockEntity)blockEntity;
                autoHammer.dropInventoryOnBreak();
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof AutoHammerBlockEntity) {
                AutoHammerBlockEntity tickable = (AutoHammerBlockEntity)t;
                if (level1.isClientSide()) {
                    tickable.tickClient();
                } else {
                    tickable.tickServer();
                }
            }
        };
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return this.props.createBlockEntity(pos, blockState);
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AutoHammerBlockEntity) {
            AutoHammerBlockEntity autoHammer = (AutoHammerBlockEntity)blockEntity;
            autoHammer.invalidateCapabilities();
            autoHammer.clearCapabilityCaches();
        }
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (!oldState.is(state.getBlock())) {
            this.checkPoweredState(level, pos, state);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        this.checkPoweredState(level, pos, state);
    }

    private void checkPoweredState(Level level, BlockPos pos, BlockState state) {
        boolean hasSignal;
        boolean bl = hasSignal = !level.hasNeighborSignal(pos);
        if (hasSignal != (Boolean)state.getValue((Property)BlockStateProperties.ENABLED)) {
            BlockState newState = (BlockState)state.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(hasSignal));
            if (!hasSignal && ((Boolean)state.getValue((Property)AbstractMachineBlock.ACTIVE)).booleanValue()) {
                newState = (BlockState)newState.setValue((Property)AbstractMachineBlock.ACTIVE, (Comparable)Boolean.valueOf(false));
            }
            level.setBlock(pos, newState, 3);
        }
    }
}

