/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.fusingmachine;

import com.google.common.collect.Sets;
import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineBlockEntity;
import dev.ftb.mods.ftbstuffnthings.blocks.FluidEnergyProcessorContainerData;
import dev.ftb.mods.ftbstuffnthings.blocks.FluidEnergyProvider;
import dev.ftb.mods.ftbstuffnthings.blocks.ProgressProvider;
import dev.ftb.mods.ftbstuffnthings.blocks.fusingmachine.FusingMachineMenu;
import dev.ftb.mods.ftbstuffnthings.capabilities.EmittingEnergy;
import dev.ftb.mods.ftbstuffnthings.capabilities.EmittingFluidTank;
import dev.ftb.mods.ftbstuffnthings.capabilities.EmittingStackHandler;
import dev.ftb.mods.ftbstuffnthings.crafting.RecipeCaches;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.FusingMachineRecipe;
import dev.ftb.mods.ftbstuffnthings.registry.BlockEntitiesRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ComponentsRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class FusingMachineBlockEntity
extends AbstractMachineBlockEntity
implements MenuProvider,
FluidEnergyProvider,
ProgressProvider {
    private final EmittingEnergy energyHandler = new EmittingEnergy(1000000, 10000, 10000, energy -> this.setChanged());
    private final ExtractOnlyFluidTank fluidHandler = new ExtractOnlyFluidTank(10000, tank -> this.setChanged());
    private final EmittingStackHandler itemHandler = new EmittingStackHandler(2, contents -> this.onItemHandlerChange());
    private int progress = 0;
    private int progressRequired = 0;
    private boolean recheckRecipe = false;
    private FusingMachineRecipe currentRecipe = null;
    private final FluidEnergyProcessorContainerData containerData = new FluidEnergyProcessorContainerData(this, this);

    public FusingMachineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntitiesRegistry.FUSING_MACHINE.get(), pos, state);
    }

    @Override
    public void tickServer(ServerLevel serverLevel) {
        if (!this.hasEnoughEnergy() || !this.hasOccupiedInputSlots()) {
            this.setActive(false);
            return;
        }
        if (this.recheckRecipe || this.progress == 0) {
            this.recheckRecipe = false;
            this.currentRecipe = RecipeCaches.FUSING_MACHINE.getCachedRecipe(this::searchForRecipe, this::genIngredientHash).map(RecipeHolder::value).orElse(null);
            if (this.currentRecipe == null || !this.fluidHandler.isEmpty() && !FluidStack.isSameFluidSameComponents((FluidStack)this.fluidHandler.getFluid(), (FluidStack)this.currentRecipe.getFluidResult())) {
                this.progress = 0;
                this.setActive(false);
                return;
            }
            this.progress = Math.max(1, this.progress);
            this.progressRequired = this.currentRecipe.getEnergyComponent().ticksToProcess();
        }
        if (this.currentRecipe != null) {
            if (this.progress == this.progressRequired) {
                if (this.canAcceptOutput()) {
                    this.executeRecipe();
                } else {
                    this.setActive(false);
                }
            } else if (this.progress < this.progressRequired) {
                this.setActive(true);
                this.useEnergy();
                ++this.progress;
            }
        }
    }

    private Optional<RecipeHolder<FusingMachineRecipe>> searchForRecipe() {
        return this.level.getRecipeManager().getAllRecipesFor(RecipesRegistry.FUSING_MACHINE_TYPE.get()).stream().sorted((h1, h2) -> ((FusingMachineRecipe)h2.value()).getInputs().size() - ((FusingMachineRecipe)h1.value()).getInputs().size()).filter(holder -> ((FusingMachineRecipe)holder.value()).test((IItemHandler)this.itemHandler)).findFirst();
    }

    private int genIngredientHash() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            l.add(ItemStack.hashItemAndComponents((ItemStack)this.itemHandler.getStackInSlot(i)));
        }
        return l.hashCode();
    }

    private void onItemHandlerChange() {
        if (!this.level.isClientSide) {
            this.setChanged();
            this.recheckRecipe = true;
        }
    }

    private boolean canAcceptOutput() {
        return this.currentRecipe != null && this.currentRecipe.getFluidResult().getAmount() + this.fluidHandler.getFluidAmount() <= this.fluidHandler.getCapacity();
    }

    private void executeRecipe() {
        Set requiredItems = Sets.newIdentityHashSet();
        requiredItems.addAll(this.currentRecipe.getInputs());
        BitSet extractingSlots = new BitSet(this.itemHandler.getSlots());
        for (Ingredient ingredient : requiredItems) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                if (extractingSlots.get(i) || !ingredient.test(this.itemHandler.getStackInSlot(i))) continue;
                if (this.itemHandler.extractItem(i, 1, true).isEmpty()) {
                    this.resetProgress();
                    this.currentRecipe = null;
                    return;
                }
                extractingSlots.set(i);
            }
        }
        if (extractingSlots.cardinality() == this.currentRecipe.getInputs().size()) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                if (!extractingSlots.get(i)) continue;
                this.itemHandler.extractItem(i, 1, false);
            }
            this.fluidHandler.fillInternal(this.currentRecipe.getFluidResult(), IFluidHandler.FluidAction.EXECUTE);
        }
        this.resetProgress();
    }

    private void useEnergy() {
        if (this.currentRecipe == null) {
            return;
        }
        int result = this.energyHandler.extractEnergy(this.currentRecipe.getEnergyComponent().fePerTick(), true);
        if (result < this.currentRecipe.getEnergyComponent().fePerTick()) {
            this.resetProgress();
            return;
        }
        this.energyHandler.extractEnergy(this.currentRecipe.getEnergyComponent().fePerTick(), false);
    }

    private void resetProgress() {
        this.progress = 0;
        this.progressRequired = 0;
    }

    private boolean hasEnoughEnergy() {
        return this.energyHandler.getEnergyStored() > (this.currentRecipe == null ? 0 : this.currentRecipe.getEnergyComponent().fePerTick());
    }

    private boolean hasOccupiedInputSlots() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.fluidHandler.needSync(sp);
        }
        return new FusingMachineMenu(windowId, inventory, this.getBlockPos());
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.itemHandler.deserializeNBT(provider, tag.getCompound("input"));
        if (tag.contains("energy")) {
            this.energyHandler.deserializeNBT(provider, tag.get("energy"));
        }
        this.fluidHandler.readFromNBT(provider, tag.getCompound("fluid"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("input", (Tag)this.itemHandler.serializeNBT(provider));
        tag.put("energy", this.energyHandler.serializeNBT(provider));
        tag.put("fluid", (Tag)this.fluidHandler.writeToNBT(provider, new CompoundTag()));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        this.loadAdditional(tag, provider);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.fluidHandler.setFluid(((SimpleFluidContent)componentInput.getOrDefault(ComponentsRegistry.STORED_FLUID, (Object)SimpleFluidContent.EMPTY)).copy());
        this.energyHandler.overrideEnergy((Integer)componentInput.getOrDefault(ComponentsRegistry.STORED_ENERGY, (Object)0));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(ComponentsRegistry.STORED_FLUID, (Object)SimpleFluidContent.copyOf((FluidStack)this.fluidHandler.getFluid()));
        components.set(ComponentsRegistry.STORED_ENERGY, (Object)this.energyHandler.getEnergyStored());
    }

    @Override
    public int getEnergy() {
        return this.energyHandler.getEnergyStored();
    }

    @Override
    public int getMaxEnergy() {
        return this.energyHandler.getMaxEnergyStored();
    }

    @Override
    public FluidStack getFluid() {
        return this.fluidHandler.getFluid();
    }

    @Override
    public int getMaxFluid() {
        return this.fluidHandler.getCapacity();
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.fluidHandler.overrideFluidStack(fluid);
    }

    @Override
    public void setEnergy(int energy) {
        this.energyHandler.overrideEnergy(energy);
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public int getMaxProgress() {
        return this.progressRequired;
    }

    @Override
    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public void setMaxProgress(int maxProgress) {
        this.progressRequired = maxProgress;
    }

    public EmittingStackHandler getItemHandler(@Nullable Direction side) {
        return this.itemHandler;
    }

    @Override
    public IFluidHandler getFluidHandler(@Nullable Direction side) {
        return this.fluidHandler;
    }

    @Override
    public IEnergyStorage getEnergyHandler(@Nullable Direction side) {
        return this.energyHandler;
    }

    @Override
    public ContainerData getContainerData() {
        return this.containerData;
    }

    public static class ExtractOnlyFluidTank
    extends EmittingFluidTank {
        public ExtractOnlyFluidTank(int capacity, Consumer<EmittingFluidTank> listener) {
            super(capacity, listener);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public int fillInternal(FluidStack resource, IFluidHandler.FluidAction action) {
            return super.fill(resource, action);
        }

        public void overrideFluidStack(FluidStack stack) {
            this.fluid = stack;
        }
    }
}

