/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.cobblegen;

import dev.ftb.mods.ftbstuffnthings.Config;
import dev.ftb.mods.ftbstuffnthings.blocks.cobblegen.CobbleGenProperties;
import dev.ftb.mods.ftbstuffnthings.registry.BlockEntitiesRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class CobblegenBlockEntity
extends BlockEntity {
    private final CobbleGenProperties props;
    protected ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            CobblegenBlockEntity.this.setChanged();
        }
    };
    private BlockCapabilityCache<IItemHandler, Direction> outputCache;
    private int ticks;

    protected CobblegenBlockEntity(BlockEntityType<?> type, CobbleGenProperties props, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.props = props;
    }

    public void tickServer() {
        ++this.ticks;
        if (!((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            return;
        }
        if (this.ticks % (Integer)Config.DELAY_PER_OPERATION.get() != 0) {
            return;
        }
        IItemHandler inv = this.getConnectedInventory();
        int amount = this.props.getCobbleGenAmount();
        if (inv != null) {
            ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)new ItemStack((ItemLike)Items.COBBLESTONE, amount), (boolean)false);
            if (!excess.isEmpty()) {
                ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)excess, (boolean)false);
                this.outputCache = null;
            }
        } else {
            ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)new ItemStack((ItemLike)Items.COBBLESTONE, amount), (boolean)false);
        }
    }

    public ItemStackHandler getInternalInventory() {
        return this.inventory;
    }

    public boolean isActive() {
        if (!((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            return false;
        }
        if (this.inventory.getStackInSlot(0).getCount() >= 64) {
            IItemHandler connectedInventory = this.getConnectedInventory();
            return connectedInventory != null && this.hasSpaceInInventory(connectedInventory);
        }
        return true;
    }

    @Nullable
    private IItemHandler getConnectedInventory() {
        if (this.outputCache == null || this.outputCache.getCapability() == null) {
            for (Direction direction : Direction.values()) {
                this.outputCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)this.getLevel()), (BlockPos)this.getBlockPos().relative(direction), null);
                IItemHandler dest = (IItemHandler)this.outputCache.getCapability();
                if (dest == null || !this.hasSpaceInInventory(dest)) continue;
                return dest;
            }
        }
        return this.outputCache == null ? null : (IItemHandler)this.outputCache.getCapability();
    }

    private boolean hasSpaceInInventory(IItemHandler inventory) {
        return ItemHandlerHelper.insertItem((IItemHandler)inventory, (ItemStack)Items.COBBLESTONE.getDefaultInstance(), (boolean)true).isEmpty();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
    }

    public static class Netherite
    extends CobblegenBlockEntity {
        public Netherite(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.NETHERITE_COBBLEGEN.get(), CobbleGenProperties.NETHERITE, pos, blockState);
        }
    }

    public static class Diamond
    extends CobblegenBlockEntity {
        public Diamond(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.DIAMOND_COBBLEGEN.get(), CobbleGenProperties.DIAMOND, pos, blockState);
        }
    }

    public static class Gold
    extends CobblegenBlockEntity {
        public Gold(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.GOLD_COBBLEGEN.get(), CobbleGenProperties.GOLD, pos, blockState);
        }
    }

    public static class Iron
    extends CobblegenBlockEntity {
        public Iron(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.IRON_COBBLEGEN.get(), CobbleGenProperties.IRON, pos, blockState);
        }
    }

    public static class Stone
    extends CobblegenBlockEntity {
        public Stone(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.STONE_COBBLEGEN.get(), CobbleGenProperties.STONE, pos, blockState);
        }
    }
}

