/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks;

import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractMachineMenu<T extends AbstractMachineBlockEntity>
extends AbstractContainerMenu {
    public final T blockEntity;
    private int playerSlotsStart;
    protected ContainerData containerData;

    public AbstractMachineMenu(MenuType type, int windowId, Inventory invPlayer, FriendlyByteBuf extraData) {
        this(type, windowId, invPlayer, AbstractMachineMenu.getTilePos(extraData));
    }

    public AbstractMachineMenu(MenuType type, int windowId, Inventory invPlayer) {
        this(type, windowId, invPlayer, (BlockPos)null);
    }

    public AbstractMachineMenu(MenuType type, int windowId, Inventory invPlayer, BlockPos blockPos) {
        super(type, windowId);
        if (blockPos != null) {
            BlockEntity te0 = invPlayer.player.level().getBlockEntity(blockPos);
            if (te0 instanceof AbstractMachineBlockEntity) {
                this.blockEntity = (AbstractMachineBlockEntity)te0;
                this.containerData = ((AbstractMachineBlockEntity)((Object)this.blockEntity)).getContainerData();
            } else {
                this.blockEntity = null;
            }
        } else {
            this.blockEntity = null;
        }
    }

    public static BlockPos getTilePos(FriendlyByteBuf buf) {
        return buf.readBlockPos();
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.blockEntity != null) {
            ((AbstractMachineBlockEntity)((Object)this.blockEntity)).syncFluidTank(true);
        }
    }

    protected void addPlayerSlots(Inventory inventoryPlayer, int yOffset) {
        this.addPlayerSlots(inventoryPlayer, 8, yOffset);
    }

    protected void addPlayerSlots(Inventory inventoryPlayer, int xOffset, int yOffset) {
        this.playerSlotsStart = this.slots.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)inventoryPlayer, col + row * 9 + 9, xOffset + col * 18, yOffset + row * 18));
            }
        }
        for (int hotbarIdx = 0; hotbarIdx < 9; ++hotbarIdx) {
            this.addSlot(new Slot((Container)inventoryPlayer, hotbarIdx, xOffset + hotbarIdx * 18, yOffset + 58));
        }
    }

    @Nonnull
    public ItemStack quickMoveStack(Player player, int slot) {
        Slot srcSlot = (Slot)this.slots.get(slot);
        if (srcSlot == null || !srcSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack srcStack = srcSlot.getItem().copy();
        ItemStack copyOfSrcStack = srcStack.copy();
        if (slot < this.playerSlotsStart ? !this.moveItemStackToHotbarOrInventory(srcStack, this.playerSlotsStart) : !this.moveItemStackTo(srcStack, 0, this.playerSlotsStart, false)) {
            return ItemStack.EMPTY;
        }
        srcSlot.set(srcStack);
        srcSlot.onQuickCraft(srcStack, copyOfSrcStack);
        srcSlot.onTake(player, srcStack);
        return copyOfSrcStack;
    }

    boolean moveItemStackToHotbarOrInventory(ItemStack stack, int startIndex) {
        return this.moveItemStackTo(stack, startIndex + 27, startIndex + 36, false) || this.moveItemStackTo(stack, startIndex, startIndex + 27, false);
    }

    public boolean stillValid(Player player) {
        if (this.blockEntity == null) {
            return false;
        }
        Vec3 position = player.position();
        return this.blockEntity.getBlockPos().distManhattan((Vec3i)BlockPos.containing((Position)position)) <= 8;
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

