/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings;

import dev.ftb.mods.ftbstuffnthings.items.MeshType;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class FTBStuffTags {

    public static class Painting {
        public static final TagKey<PaintingVariant> DROPS_WITH_VARIANT = Painting.modTag("drops_with_variant");

        static TagKey<PaintingVariant> tag(String modid, String name) {
            return TagKey.create((ResourceKey)Registries.PAINTING_VARIANT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
        }

        static TagKey<PaintingVariant> modTag(String name) {
            return Painting.tag("ftbstuff", name);
        }
    }

    public static class Items {
        public static final TagKey<Item> INGOTS_CAST_IRON = Items.commonTag("ingots/cast_iron");
        public static final TagKey<Item> NUGGETS_CAST_IRON = Items.commonTag("nuggets/cast_iron");
        public static final TagKey<Item> GEARS = Items.commonTag("gears");
        public static final TagKey<Item> GEARS_CAST_IRON = Items.commonTag("gears/cast_iron");
        public static final TagKey<Item> HAMMERS = Items.modTag("hammers");
        public static final TagKey<Item> CROOKS = Items.modTag("crooks");
        public static final TagKey<Item> MESHES = Items.modTag("meshes");

        static TagKey<Item> tag(String modid, String name) {
            return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
        }

        static TagKey<Item> modTag(String name) {
            return Items.tag("ftbstuff", name);
        }

        static TagKey<Item> commonTag(String name) {
            return Items.tag("c", name);
        }
    }

    public static class Blocks {
        public static final TagKey<Block> MINEABLE_WITH_HAMMER = Blocks.commonTag("mineable/hammer");
        public static final TagKey<Block> CRATE = Blocks.modTag("crate");
        public static final TagKey<Block> BARREL = Blocks.modTag("barrel");
        public static final TagKey<Block> WATER_STRAINER = Blocks.modTag("water_strainer");
        public static final TagKey<Block> SLUICE = Blocks.modTag("sluice");
        private static final Map<MeshType, TagKey<Block>> ALLOWED_MESHES = (Map)Util.make(new EnumMap(MeshType.class), map -> MeshType.NON_EMPTY_VALUES.forEach(mesh -> map.put(mesh, Blocks.modTag("allowed_meshes/" + mesh.getSerializedName()))));

        public static TagKey<Block> allowedMeshes(MeshType type) {
            return ALLOWED_MESHES.get((Object)type);
        }

        static TagKey<Block> tag(String modid, String name) {
            return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
        }

        static TagKey<Block> modTag(String name) {
            return Blocks.tag("ftbstuff", name);
        }

        static TagKey<Block> commonTag(String name) {
            return Blocks.tag("c", name);
        }
    }
}

