/*
 * Decompiled with CFR 0.152.
 */
package tfar.metalbarrels.datagen.assets;

import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.codehaus.plexus.util.StringUtils;
import tfar.metalbarrels.datagen.ModDatagen;
import tfar.metalbarrels.init.ModCreativeTabs;

public class ModLangProvider
extends LanguageProvider {
    public ModLangProvider(PackOutput output) {
        super(output, "metalbarrels", "en_us");
    }

    protected void addTranslations() {
        for (Block block : ModDatagen.getKnownBlocks().toList()) {
            this.addDefaultBlock(() -> block);
        }
        for (Item item : ModDatagen.getKnownItems().toList()) {
            if (item instanceof BlockItem) continue;
            this.addDefaultItem(() -> item);
        }
        this.addGroup(ModCreativeTabs.tab, "Metal Barrels");
        this.add("metalbarrels.upgrade_successful", "Upgrade Successful");
        this.add("metalbarrels.in_use", "Barrel is in Use");
    }

    protected void addGroup(CreativeModeTab group, String name) {
        this.add(group.getDisplayName().getString(), name);
    }

    protected void addDefaultItem(Supplier<? extends Item> supplier) {
        this.addItem(supplier, ModLangProvider.getNameFromItem(supplier.get()));
    }

    protected void addDefaultBlock(Supplier<? extends Block> supplier) {
        this.addBlock(supplier, ModLangProvider.getNameFromBlock(supplier.get()));
    }

    public static String getNameFromBlock(Block block) {
        return StringUtils.capitaliseAllWords((String)block.getDescriptionId().split("\\.")[2].replace("_", " "));
    }

    public static String getNameFromItem(Item item) {
        return StringUtils.capitaliseAllWords((String)item.getDescriptionId().split("\\.")[2].replace("_", " "));
    }
}

