/*
 * Decompiled with CFR 0.152.
 */
package tfar.metalbarrels.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import tfar.metalbarrels.datagen.assets.ModItemModelProvider;
import tfar.metalbarrels.datagen.assets.ModLangProvider;
import tfar.metalbarrels.datagen.data.ModBlockLoot;
import tfar.metalbarrels.datagen.data.ModBlockTagsProvider;
import tfar.metalbarrels.datagen.data.ModItemTagsProvider;
import tfar.metalbarrels.datagen.data.ModLootTableProvider;
import tfar.metalbarrels.datagen.data.ModRecipeProvider;

public class ModDatagen {
    public static void start(GatherDataEvent e) {
        DataGenerator generator = e.getGenerator();
        ExistingFileHelper helper = e.getExistingFileHelper();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = e.getLookupProvider();
        boolean client = e.includeClient();
        boolean server = e.includeServer();
        boolean dev = e.includeDev();
        generator.addProvider(client, (DataProvider)new ModLangProvider(output));
        generator.addProvider(client, (DataProvider)new ModItemModelProvider(output, helper));
        generator.addProvider(server, (DataProvider)new ModRecipeProvider(output, provider));
        ModBlockTagsProvider blockTagsProvider = new ModBlockTagsProvider(output, provider, helper);
        generator.addProvider(server, (DataProvider)blockTagsProvider);
        generator.addProvider(server, (DataProvider)new ModItemTagsProvider(output, provider, blockTagsProvider, helper));
        generator.addProvider(server, (DataProvider)new ModLootTableProvider(output, List.of(new LootTableProvider.SubProviderEntry(ModBlockLoot::new, LootContextParamSets.BLOCK)), provider));
    }

    public static Stream<Block> getKnownBlocks() {
        return ModDatagen.getKnown(BuiltInRegistries.BLOCK);
    }

    public static Stream<Item> getKnownItems() {
        return ModDatagen.getKnown(BuiltInRegistries.ITEM);
    }

    public static <V> Stream<V> getKnown(Registry<V> registry) {
        return registry.stream().filter(o -> registry.getKey(o).getNamespace().equals("metalbarrels"));
    }
}

