/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.proxy;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.network.IPacketHandler;
import org.cyclops.cyclopscore.proxy.CommonProxyComponentCommon;
import org.cyclops.cyclopscore.proxy.IClientProxyCommon;
import org.cyclops.cyclopscore.proxy.ICommonProxyCommon;

public abstract class ClientProxyComponentCommon
extends CommonProxyComponentCommon
implements ICommonProxyCommon,
IClientProxyCommon {
    private final CommonProxyComponentCommon commonProxyComponent;
    protected final Map<BlockEntityType, BlockEntityRendererProvider> blockEntityRenderers = Maps.newHashMap();

    public ClientProxyComponentCommon(CommonProxyComponentCommon commonProxyComponent) {
        this.commonProxyComponent = commonProxyComponent;
    }

    public CommonProxyComponentCommon getCommonProxyComponent() {
        return this.commonProxyComponent;
    }

    public Map<BlockEntityType, BlockEntityRendererProvider> getBlockEntityRenderers() {
        return this.blockEntityRenderers;
    }

    @Override
    public <T extends BlockEntity> void registerRenderer(BlockEntityType<? extends T> blockEntityType, BlockEntityRendererProvider<T> rendererFactory) {
        this.blockEntityRenderers.put(blockEntityType, rendererFactory);
    }

    @Override
    public void registerRenderers() {
        for (Map.Entry<BlockEntityType, BlockEntityRendererProvider> entry : this.blockEntityRenderers.entrySet()) {
            BlockEntityRenderers.register((BlockEntityType)entry.getKey(), (BlockEntityRendererProvider)entry.getValue());
            this.getMod().getLoggerHelper().log(Level.TRACE, String.format("Registered %s special renderer %s", entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public void registerTickHandlers() {
        this.commonProxyComponent.registerTickHandlers();
        this.getMod().getLoggerHelper().log(Level.TRACE, "Registered tick handlers");
    }

    @Override
    public void registerEventHooks() {
        this.commonProxyComponent.registerEventHooks();
        this.getMod().getLoggerHelper().log(Level.TRACE, "Registered event hooks");
    }

    @Override
    public void registerPackets(IPacketHandler packetHandler) {
        this.commonProxyComponent.registerPackets(packetHandler);
        this.getMod().getLoggerHelper().log(Level.TRACE, "Registered packet handlers");
    }
}

